/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.pitch.PitchDetectionResult;
import be.tarsos.dsp.pitch.PitchDetector;
import java.util.Arrays;

public class DynamicWavelet
implements PitchDetector {
    private final int maxFLWTlevels = 6;
    private final double maxF = 3000.0;
    private final int differenceLevelsN = 3;
    private final double maximaThresholdRatio = 0.75;
    private final PitchDetectionResult result;
    private final float sampleRate;
    int[] distances;
    int[] mins;
    int[] maxs;

    public DynamicWavelet(float f, int n) {
        this.sampleRate = f;
        this.distances = new int[n];
        this.mins = new int[n];
        this.maxs = new int[n];
        this.result = new PitchDetectionResult();
    }

    @Override
    public PitchDetectionResult getPitch(float[] fArray) {
        float f = -1.0f;
        int n = fArray.length;
        if (this.distances.length == fArray.length) {
            Arrays.fill(this.distances, 0);
            Arrays.fill(this.mins, 0);
            Arrays.fill(this.maxs, 0);
        } else {
            this.distances = new int[fArray.length];
            this.mins = new int[fArray.length];
            this.maxs = new int[fArray.length];
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            double d4 = fArray[i];
            d += d4;
            d2 = Math.max(d2, d4);
            d3 = Math.min(d4, d3);
        }
        double d5 = (d2 -= (d /= (double)fArray.length)) > -(d3 -= d) ? d2 : -d3;
        double d6 = d5 * 0.75;
        int n2 = 0;
        double d7 = -1.0;
        while (true) {
            double d8;
            int n3;
            int n4;
            int n5;
            double d9;
            int n6;
            int n7 = (int)((double)this.sampleRate / (Math.pow(2.0, n2) * 3000.0));
            if (n < 2) break;
            double d10 = -1000.0;
            int n8 = 0;
            int n9 = 0;
            int n10 = -1000000;
            int n11 = -1000000;
            boolean bl = false;
            boolean bl2 = false;
            for (n6 = 2; n6 < n; ++n6) {
                double d11 = (double)fArray[n6] - d;
                d9 = (double)fArray[n6 - 1] - d;
                if (d9 <= 0.0 && d11 > 0.0) {
                    bl = true;
                }
                if (d9 >= 0.0 && d11 < 0.0) {
                    bl2 = true;
                }
                double d12 = d11 - d9;
                if (d10 > -1000.0) {
                    if (bl2 && d10 < 0.0 && d12 >= 0.0 && Math.abs(d11) >= d6 && n6 > n10 + n7) {
                        this.mins[n9++] = n6;
                        n10 = n6;
                        bl2 = false;
                    }
                    if (bl && d10 > 0.0 && d12 <= 0.0 && Math.abs(d11) >= d6 && n6 > n11 + n7) {
                        this.maxs[n8++] = n6;
                        n11 = n6;
                        bl = false;
                    }
                }
                d10 = d12;
            }
            if (n9 == 0 && n8 == 0) break;
            Arrays.fill(this.distances, 0);
            for (n5 = 0; n5 < n9; ++n5) {
                for (n4 = 1; n4 < 3; ++n4) {
                    if (n5 + n4 >= n9) continue;
                    n6 = Math.abs(this.mins[n5] - this.mins[n5 + n4]);
                    this.distances[n6] = this.distances[n6] + 1;
                }
            }
            n5 = -1;
            n4 = -1;
            for (int i = 0; i < n; ++i) {
                int n12 = 0;
                for (int j = -n7; j <= n7; ++j) {
                    if (i + j < 0 || i + j >= n) continue;
                    n12 += this.distances[i + j];
                }
                if (n12 == n4) {
                    if (i != 2 * n5) continue;
                    n5 = i;
                    continue;
                }
                if (n12 <= n4) continue;
                n4 = n12;
                n5 = i;
            }
            d9 = 0.0;
            double d13 = 0.0;
            for (int i = -n7; i <= n7; ++i) {
                if (n5 + i < 0 || n5 + i >= fArray.length || (n3 = this.distances[n5 + i]) <= 0) continue;
                d13 += (double)n3;
                d9 += (double)((n5 + i) * n3);
            }
            d9 /= d13;
            if (d7 > -1.0 && (d8 = Math.abs(d9 * 2.0 - d7)) <= (double)(2 * n7)) {
                f = (float)((double)this.sampleRate / (Math.pow(2.0, n2 - 1) * d7));
                break;
            }
            d7 = d9;
            if (++n2 >= 6 || n < 2) break;
            float[] fArray2 = fArray;
            if (n == this.distances.length) {
                fArray2 = new float[n / 2];
            }
            for (n3 = 0; n3 < n / 2; ++n3) {
                fArray2[n3] = (fArray[2 * n3] + fArray[2 * n3 + 1]) / 2.0f;
            }
            fArray = fArray2;
            n /= 2;
        }
        this.result.setPitch(f);
        this.result.setPitched(-1.0f != f);
        this.result.setProbability(-1.0f);
        return this.result;
    }
}

