/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.pitch.PitchDetectionResult;
import be.tarsos.dsp.pitch.PitchDetector;
import be.tarsos.dsp.util.fft.FloatFFT;

public final class FastYin
implements PitchDetector {
    private static final double DEFAULT_THRESHOLD = 0.2;
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    public static final int DEFAULT_OVERLAP = 1536;
    private final double threshold;
    private final float sampleRate;
    private final float[] yinBuffer;
    private final PitchDetectionResult result;
    private final float[] audioBufferFFT;
    private final float[] kernel;
    private final float[] yinStyleACF;
    private final FloatFFT fft;

    public FastYin(float f, int n) {
        this(f, n, 0.2);
    }

    public FastYin(float f, int n, double d) {
        this.sampleRate = f;
        this.threshold = d;
        this.yinBuffer = new float[n / 2];
        this.audioBufferFFT = new float[2 * n];
        this.kernel = new float[2 * n];
        this.yinStyleACF = new float[2 * n];
        this.fft = new FloatFFT(n);
        this.result = new PitchDetectionResult();
    }

    @Override
    public PitchDetectionResult getPitch(float[] fArray) {
        float f;
        this.difference(fArray);
        this.cumulativeMeanNormalizedDifference();
        int n = this.absoluteThreshold();
        if (n != -1) {
            float f2 = this.parabolicInterpolation(n);
            f = this.sampleRate / f2;
        } else {
            f = -1.0f;
        }
        this.result.setPitch(f);
        return this.result;
    }

    private void difference(float[] fArray) {
        int n;
        float[] fArray2 = new float[this.yinBuffer.length];
        for (n = 0; n < this.yinBuffer.length; ++n) {
            fArray2[0] = fArray2[0] + fArray[n] * fArray[n];
        }
        for (n = 1; n < this.yinBuffer.length; ++n) {
            fArray2[n] = fArray2[n - 1] - fArray[n - 1] * fArray[n - 1] + fArray[n + this.yinBuffer.length] * fArray[n + this.yinBuffer.length];
        }
        for (n = 0; n < fArray.length; ++n) {
            this.audioBufferFFT[2 * n] = fArray[n];
            this.audioBufferFFT[2 * n + 1] = 0.0f;
        }
        this.fft.complexForward(this.audioBufferFFT);
        for (n = 0; n < this.yinBuffer.length; ++n) {
            this.kernel[2 * n] = fArray[this.yinBuffer.length - 1 - n];
            this.kernel[2 * n + 1] = 0.0f;
            this.kernel[2 * n + fArray.length] = 0.0f;
            this.kernel[2 * n + fArray.length + 1] = 0.0f;
        }
        this.fft.complexForward(this.kernel);
        for (n = 0; n < fArray.length; ++n) {
            this.yinStyleACF[2 * n] = this.audioBufferFFT[2 * n] * this.kernel[2 * n] - this.audioBufferFFT[2 * n + 1] * this.kernel[2 * n + 1];
            this.yinStyleACF[2 * n + 1] = this.audioBufferFFT[2 * n + 1] * this.kernel[2 * n] + this.audioBufferFFT[2 * n] * this.kernel[2 * n + 1];
        }
        this.fft.complexInverse(this.yinStyleACF, true);
        for (n = 0; n < this.yinBuffer.length; ++n) {
            this.yinBuffer[n] = fArray2[0] + fArray2[n] - 2.0f * this.yinStyleACF[2 * (this.yinBuffer.length - 1 + n)];
        }
    }

    private void cumulativeMeanNormalizedDifference() {
        this.yinBuffer[0] = 1.0f;
        float f = 0.0f;
        for (int i = 1; i < this.yinBuffer.length; ++i) {
            int n = i;
            this.yinBuffer[n] = this.yinBuffer[n] * ((float)i / (f += this.yinBuffer[i]));
        }
    }

    private int absoluteThreshold() {
        int n;
        for (n = 2; n < this.yinBuffer.length; ++n) {
            if (!((double)this.yinBuffer[n] < this.threshold)) continue;
            while (n + 1 < this.yinBuffer.length && this.yinBuffer[n + 1] < this.yinBuffer[n]) {
                ++n;
            }
            this.result.setProbability(1.0f - this.yinBuffer[n]);
            break;
        }
        if (n == this.yinBuffer.length || (double)this.yinBuffer[n] >= this.threshold || (double)this.result.getProbability() > 1.0) {
            n = -1;
            this.result.setProbability(0.0f);
            this.result.setPitched(false);
        } else {
            this.result.setPitched(true);
        }
        return n;
    }

    private float parabolicInterpolation(int n) {
        float f;
        int n2 = n < 1 ? n : n - 1;
        int n3 = n + 1 < this.yinBuffer.length ? n + 1 : n;
        if (n2 == n) {
            f = this.yinBuffer[n] <= this.yinBuffer[n3] ? (float)n : (float)n3;
        } else if (n3 == n) {
            f = this.yinBuffer[n] <= this.yinBuffer[n2] ? (float)n : (float)n2;
        } else {
            float f2 = this.yinBuffer[n2];
            float f3 = this.yinBuffer[n];
            float f4 = this.yinBuffer[n3];
            f = (float)n + (f4 - f2) / (2.0f * (2.0f * f3 - f4 - f2));
        }
        return f;
    }
}

