/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.pitch.Goertzel;
import be.tarsos.dsp.util.Complex;
import be.tarsos.dsp.util.fft.HammingWindow;

public class GeneralizedGoertzel
implements AudioProcessor {
    private final double[] frequenciesToDetect;
    private final double[] indvec;
    private final double[] precalculatedCosines;
    private final double[] precalculatedWnk;
    private final double[] calculatedPowers;
    private final Complex[] calculatedComplex;
    private final Goertzel.FrequenciesDetectedHandler handler;

    public GeneralizedGoertzel(float f, int n, double[] dArray, Goertzel.FrequenciesDetectedHandler frequenciesDetectedHandler) {
        int n2;
        this.frequenciesToDetect = dArray;
        this.indvec = new double[this.frequenciesToDetect.length];
        for (n2 = 0; n2 < this.frequenciesToDetect.length; ++n2) {
            this.indvec[n2] = this.frequenciesToDetect[n2] / (double)(f / (float)n);
        }
        this.precalculatedCosines = new double[dArray.length];
        this.precalculatedWnk = new double[dArray.length];
        this.handler = frequenciesDetectedHandler;
        this.calculatedPowers = new double[dArray.length];
        this.calculatedComplex = new Complex[dArray.length];
        for (n2 = 0; n2 < this.frequenciesToDetect.length; ++n2) {
            this.precalculatedCosines[n2] = 2.0 * Math.cos(Math.PI * 2 * this.frequenciesToDetect[n2] / (double)f);
            this.precalculatedWnk[n2] = Math.exp(Math.PI * -2 * this.frequenciesToDetect[n2] / (double)f);
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        HammingWindow hammingWindow = new HammingWindow();
        hammingWindow.apply(fArray);
        for (int i = 0; i < this.frequenciesToDetect.length; ++i) {
            double d = Math.PI * 2 * this.indvec[i] / (double)audioEvent.getBufferSize();
            double d2 = Math.cos(d) * 2.0;
            Complex complex = new Complex(0.0, -1.0 * d).exp();
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            for (int j = 0; j < audioEvent.getBufferSize(); ++j) {
                d3 = (double)fArray[j] + d2 * d4 - d5;
                d5 = d4;
                d4 = d3;
            }
            d3 = d2 * d4 - d5;
            this.calculatedComplex[i] = complex.times(new Complex(-d4, 0.0)).plus(new Complex(d3, 0.0));
            this.calculatedPowers[i] = this.calculatedComplex[i].mod();
        }
        this.handler.handleDetectedFrequencies(audioEvent.getTimeStamp(), (double[])this.frequenciesToDetect.clone(), (double[])this.calculatedPowers.clone(), (double[])this.frequenciesToDetect.clone(), (double[])this.calculatedPowers.clone());
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

