/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class Goertzel
implements AudioProcessor {
    private static final double POWER_THRESHOLD = 35.0;
    private final double[] frequenciesToDetect;
    private final double[] precalculatedCosines;
    private final double[] precalculatedWnk;
    private final double[] calculatedPowers;
    private final FrequenciesDetectedHandler handler;

    public Goertzel(float f, int n, double[] dArray, FrequenciesDetectedHandler frequenciesDetectedHandler) {
        this.frequenciesToDetect = dArray;
        this.precalculatedCosines = new double[dArray.length];
        this.precalculatedWnk = new double[dArray.length];
        this.handler = frequenciesDetectedHandler;
        this.calculatedPowers = new double[dArray.length];
        for (int i = 0; i < this.frequenciesToDetect.length; ++i) {
            this.precalculatedCosines[i] = 2.0 * Math.cos(Math.PI * 2 * this.frequenciesToDetect[i] / (double)f);
            this.precalculatedWnk[i] = Math.exp(Math.PI * -2 * this.frequenciesToDetect[i] / (double)f);
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        int n = 0;
        for (int i = 0; i < this.frequenciesToDetect.length; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int j = 0; j < fArray.length; ++j) {
                d = d2;
                d2 = d3;
                d3 = this.precalculatedCosines[i] * d2 - d + (double)fArray[j];
            }
            double d4 = this.precalculatedWnk[i];
            this.calculatedPowers[i] = 20.0 * Math.log10(Math.abs(d3 - d4 * d2));
            if (!(this.calculatedPowers[i] > 35.0)) continue;
            ++n;
        }
        if (n > 0) {
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            int n2 = 0;
            for (int i = 0; i < this.frequenciesToDetect.length; ++i) {
                if (!(this.calculatedPowers[i] > 35.0)) continue;
                dArray[n2] = this.frequenciesToDetect[i];
                dArray2[n2] = this.calculatedPowers[i];
                ++n2;
            }
            this.handler.handleDetectedFrequencies(audioEvent.getTimeStamp(), dArray, dArray2, (double[])this.frequenciesToDetect.clone(), (double[])this.calculatedPowers.clone());
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public static interface FrequenciesDetectedHandler {
        public void handleDetectedFrequencies(double var1, double[] var3, double[] var4, double[] var5, double[] var6);
    }
}

