/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.pitch.PitchDetectionResult;
import be.tarsos.dsp.pitch.PitchDetector;
import java.util.ArrayList;
import java.util.List;

public final class McLeodPitchMethod
implements PitchDetector {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final int DEFAULT_OVERLAP = 768;
    private static final double DEFAULT_CUTOFF = 0.97;
    private static final double SMALL_CUTOFF = 0.5;
    private static final double LOWER_PITCH_CUTOFF = 80.0;
    private final double cutoff;
    private final float sampleRate;
    private final float[] nsdf;
    private float turningPointX;
    private float turningPointY;
    private final List<Integer> maxPositions = new ArrayList<Integer>();
    private final List<Float> periodEstimates = new ArrayList<Float>();
    private final List<Float> ampEstimates = new ArrayList<Float>();
    private final PitchDetectionResult result;

    public McLeodPitchMethod(float f) {
        this(f, 1024, 0.97);
    }

    public McLeodPitchMethod(float f, int n) {
        this(f, n, 0.97);
    }

    public McLeodPitchMethod(float f, int n, double d) {
        this.sampleRate = f;
        this.nsdf = new float[n];
        this.cutoff = d;
        this.result = new PitchDetectionResult();
    }

    private void normalizedSquareDifference(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            float f = 0.0f;
            float f2 = 0.0f;
            for (int j = 0; j < fArray.length - i; ++j) {
                f += fArray[j] * fArray[j + i];
                f2 += fArray[j] * fArray[j] + fArray[j + i] * fArray[j + i];
            }
            this.nsdf[i] = 2.0f * f / f2;
        }
    }

    @Override
    public PitchDetectionResult getPitch(float[] fArray) {
        float f;
        this.maxPositions.clear();
        this.periodEstimates.clear();
        this.ampEstimates.clear();
        this.normalizedSquareDifference(fArray);
        this.peakPicking();
        double d = Double.NEGATIVE_INFINITY;
        for (Integer n : this.maxPositions) {
            d = Math.max(d, (double)this.nsdf[n]);
            if (!((double)this.nsdf[n] > 0.5)) continue;
            this.parabolicInterpolation(n);
            this.ampEstimates.add(Float.valueOf(this.turningPointY));
            this.periodEstimates.add(Float.valueOf(this.turningPointX));
            d = Math.max(d, (double)this.turningPointY);
        }
        if (this.periodEstimates.isEmpty()) {
            f = -1.0f;
        } else {
            double d2;
            float f2;
            double d3 = this.cutoff * d;
            int n = 0;
            for (int i = 0; i < this.ampEstimates.size(); ++i) {
                if (!((double)this.ampEstimates.get(i).floatValue() >= d3)) continue;
                n = i;
                break;
            }
            f = (double)(f2 = (float)((double)this.sampleRate / (d2 = (double)this.periodEstimates.get(n).floatValue()))) > 80.0 ? f2 : -1.0f;
        }
        this.result.setProbability((float)d);
        this.result.setPitch(f);
        this.result.setPitched(f != -1.0f);
        return this.result;
    }

    private void parabolicInterpolation(int n) {
        float f = this.nsdf[n - 1];
        float f2 = this.nsdf[n];
        float f3 = this.nsdf[n + 1];
        float f4 = n;
        float f5 = f3 + f - 2.0f * f2;
        if ((double)f5 == 0.0) {
            this.turningPointX = f4;
            this.turningPointY = f2;
        } else {
            float f6 = f - f3;
            this.turningPointX = f4 + f6 / (2.0f * f5);
            this.turningPointY = f2 - f6 * f6 / (8.0f * f5);
        }
    }

    private void peakPicking() {
        int n;
        int n2 = 0;
        for (n = 0; n < (this.nsdf.length - 1) / 3 && this.nsdf[n] > 0.0f; ++n) {
        }
        while (n < this.nsdf.length - 1 && (double)this.nsdf[n] <= 0.0) {
            ++n;
        }
        if (n == 0) {
            n = 1;
        }
        while (n < this.nsdf.length - 1) {
            assert (this.nsdf[n] >= 0.0f);
            if (this.nsdf[n] > this.nsdf[n - 1] && this.nsdf[n] >= this.nsdf[n + 1]) {
                if (n2 == 0) {
                    n2 = n;
                } else if (this.nsdf[n] > this.nsdf[n2]) {
                    n2 = n;
                }
            }
            if (++n >= this.nsdf.length - 1 || !(this.nsdf[n] <= 0.0f)) continue;
            if (n2 > 0) {
                this.maxPositions.add(n2);
                n2 = 0;
            }
            while (n < this.nsdf.length - 1 && this.nsdf[n] <= 0.0f) {
                ++n;
            }
        }
        if (n2 > 0) {
            this.maxPositions.add(n2);
        }
    }
}

