/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.pitch.AMDF;
import be.tarsos.dsp.pitch.DynamicWavelet;
import be.tarsos.dsp.pitch.FFTPitch;
import be.tarsos.dsp.pitch.FastYin;
import be.tarsos.dsp.pitch.McLeodPitchMethod;
import be.tarsos.dsp.pitch.PitchDetectionHandler;
import be.tarsos.dsp.pitch.PitchDetectionResult;
import be.tarsos.dsp.pitch.PitchDetector;
import be.tarsos.dsp.pitch.Yin;

public class PitchProcessor
implements AudioProcessor {
    private final PitchDetector detector;
    private final PitchDetectionHandler handler;

    public PitchProcessor(PitchEstimationAlgorithm pitchEstimationAlgorithm, float f, int n, PitchDetectionHandler pitchDetectionHandler) {
        this.detector = pitchEstimationAlgorithm.getDetector(f, n);
        this.handler = pitchDetectionHandler;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        PitchDetectionResult pitchDetectionResult = this.detector.getPitch(fArray);
        this.handler.handlePitch(pitchDetectionResult, audioEvent);
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public static enum PitchEstimationAlgorithm {
        YIN,
        MPM,
        FFT_YIN,
        DYNAMIC_WAVELET,
        FFT_PITCH,
        AMDF;


        public PitchDetector getDetector(float f, int n) {
            PitchDetector pitchDetector = this == MPM ? new McLeodPitchMethod(f, n) : (this == DYNAMIC_WAVELET ? new DynamicWavelet(f, n) : (this == FFT_YIN ? new FastYin(f, n) : (this == AMDF ? new AMDF(f, n) : (this == FFT_PITCH ? new FFTPitch(Math.round(f), n) : new Yin(f, n)))));
            return pitchDetector;
        }
    }
}

