/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.resample;

class FilterKit {
    private static final double IzeroEPSILON = 1.0E-21;

    FilterKit() {
    }

    private static double Izero(double d) {
        double d2;
        double d3;
        int n = 1;
        double d4 = d3 = (double)1;
        double d5 = d / 2.0;
        do {
            d2 = d5 / (double)n;
            ++n;
        } while ((d3 *= (d2 *= d2)) >= 1.0E-21 * (d4 += d3));
        return d4;
    }

    public static void lrsLpFilter(double[] dArray, int n, double d, double d2, int n2) {
        double d3;
        int n3;
        dArray[0] = 2.0 * d;
        for (n3 = 1; n3 < n; ++n3) {
            d3 = Math.PI * (double)n3 / (double)n2;
            dArray[n3] = Math.sin(2.0 * d3 * d) / d3;
        }
        double d4 = 1.0 / FilterKit.Izero(d2);
        double d5 = 1.0 / (double)(n - 1);
        n3 = 1;
        while (n3 < n) {
            d3 = (double)n3 * d5;
            double d6 = 1.0 - d3 * d3;
            d6 = d6 < 0.0 ? 0.0 : d6;
            int n4 = n3++;
            dArray[n4] = dArray[n4] * (FilterKit.Izero(d2 * Math.sqrt(d6)) * d4);
        }
    }

    public static float lrsFilterUp(float[] fArray, float[] fArray2, int n, boolean bl, float[] fArray3, int n2, double d, int n3) {
        double d2 = 0.0;
        float f = 0.0f;
        float[] fArray4 = fArray;
        int n4 = (int)(d *= 4096.0);
        int n5 = n;
        float[] fArray5 = fArray2;
        int n6 = (int)d;
        if (bl) {
            d2 = d - Math.floor(d);
        }
        if (n3 == 1) {
            --n5;
            if (d == 0.0) {
                n4 += 4096;
                n6 += 4096;
            }
        }
        if (bl) {
            while (n4 < n5) {
                float f2 = fArray4[n4];
                f2 = (float)((double)f2 + (double)fArray5[n6] * d2);
                n6 += 4096;
                f += (f2 *= fArray3[n2]);
                n4 += 4096;
                n2 += n3;
            }
        } else {
            while (n4 < n5) {
                float f3 = fArray4[n4];
                f += (f3 *= fArray3[n2]);
                n4 += 4096;
                n2 += n3;
            }
        }
        return f;
    }

    public static float lrsFilterUD(float[] fArray, float[] fArray2, int n, boolean bl, float[] fArray3, int n2, double d, int n3, double d2) {
        float f = 0.0f;
        double d3 = d * d2;
        int n4 = n;
        if (n3 == 1) {
            --n4;
            if (d == 0.0) {
                d3 += d2;
            }
        }
        float[] fArray4 = fArray;
        if (bl) {
            int n5;
            float[] fArray5 = fArray2;
            while ((n5 = (int)d3) < n4) {
                float f2 = fArray4[n5];
                int n6 = (int)d3;
                float f3 = (float)(d3 - Math.floor(d3));
                f2 += fArray5[n6] * f3;
                f += (f2 *= fArray3[n2]);
                d3 += d2;
                n2 += n3;
            }
        } else {
            int n7;
            while ((n7 = (int)d3) < n4) {
                float f4 = fArray4[n7];
                f += (f4 *= fArray3[n2]);
                d3 += d2;
                n2 += n3;
            }
        }
        return f;
    }
}

