/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.resample;

import be.tarsos.dsp.resample.FilterKit;
import be.tarsos.dsp.resample.SampleBuffers;
import java.nio.FloatBuffer;

public class Resampler {
    protected static final int Npc = 4096;
    private final float[] Imp;
    private final float[] ImpD;
    private final float LpScl;
    private final int Nmult;
    private final int Nwing;
    private final double minFactor;
    private final double maxFactor;
    private final int XSize;
    private final float[] X;
    private int Xp;
    private int Xread;
    private final int Xoff;
    private final float[] Y;
    private int Yp;
    private double Time;

    public Resampler(Resampler resampler) {
        this.Imp = (float[])resampler.Imp.clone();
        this.ImpD = (float[])resampler.ImpD.clone();
        this.LpScl = resampler.LpScl;
        this.Nmult = resampler.Nmult;
        this.Nwing = resampler.Nwing;
        this.minFactor = resampler.minFactor;
        this.maxFactor = resampler.maxFactor;
        this.XSize = resampler.XSize;
        this.X = (float[])resampler.X.clone();
        this.Xp = resampler.Xp;
        this.Xread = resampler.Xread;
        this.Xoff = resampler.Xoff;
        this.Y = (float[])resampler.Y.clone();
        this.Yp = resampler.Yp;
        this.Time = resampler.Time;
    }

    public Resampler(boolean bl, double d, double d2) {
        int n;
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("minFactor and maxFactor must be positive");
        }
        if (d2 < d) {
            throw new IllegalArgumentException("minFactor must be <= maxFactor");
        }
        this.minFactor = d;
        this.maxFactor = d2;
        this.Nmult = bl ? 35 : 11;
        this.LpScl = 1.0f;
        this.Nwing = 4096 * (this.Nmult - 1) / 2;
        double d3 = 0.9;
        double d4 = 6.0;
        double[] dArray = new double[this.Nwing];
        FilterKit.lrsLpFilter(dArray, this.Nwing, 0.5 * d3, d4, 4096);
        this.Imp = new float[this.Nwing];
        this.ImpD = new float[this.Nwing];
        for (n = 0; n < this.Nwing; ++n) {
            this.Imp[n] = (float)dArray[n];
        }
        for (n = 0; n < this.Nwing - 1; ++n) {
            this.ImpD[n] = this.Imp[n + 1] - this.Imp[n];
        }
        this.ImpD[this.Nwing - 1] = -this.Imp[this.Nwing - 1];
        n = (int)((double)(this.Nmult + 1) / 2.0 * Math.max(1.0, 1.0 / d) + 10.0);
        int n2 = (int)((double)(this.Nmult + 1) / 2.0 * Math.max(1.0, 1.0 / d2) + 10.0);
        this.Xoff = Math.max(n, n2);
        this.XSize = Math.max(2 * this.Xoff + 10, 4096);
        this.X = new float[this.XSize + this.Xoff];
        this.Xp = this.Xoff;
        this.Xread = this.Xoff;
        int n3 = (int)((double)this.XSize * d2 + 2.0);
        this.Y = new float[n3];
        this.Yp = 0;
        this.Time = this.Xoff;
    }

    public int getFilterWidth() {
        return this.Xoff;
    }

    public boolean process(double d, SampleBuffers sampleBuffers, boolean bl) {
        int n;
        int n2;
        if (d < this.minFactor || d > this.maxFactor) {
            throw new IllegalArgumentException("factor " + d + " is not between minFactor=" + this.minFactor + " and maxFactor=" + this.maxFactor);
        }
        int n3 = sampleBuffers.getOutputBufferLength();
        int n4 = sampleBuffers.getInputBufferLength();
        float[] fArray = this.Imp;
        float[] fArray2 = this.ImpD;
        float f = this.LpScl;
        int n5 = this.Nwing;
        boolean bl2 = false;
        int n6 = 0;
        int n7 = 0;
        if (this.Yp != 0 && n3 - n7 > 0) {
            n2 = Math.min(n3 - n7, this.Yp);
            sampleBuffers.consumeOutput(this.Y, 0, n2);
            n7 += n2;
            for (n = 0; n < this.Yp - n2; ++n) {
                this.Y[n] = this.Y[n + n2];
            }
            this.Yp -= n2;
        }
        if (this.Yp != 0) {
            return n6 == 0 && n7 == 0;
        }
        if (d < 1.0) {
            f = (float)((double)f * d);
        }
        do {
            int n8;
            int n9;
            if ((n2 = this.XSize - this.Xread) >= n4 - n6) {
                n2 = n4 - n6;
            }
            sampleBuffers.produceInput(this.X, this.Xread, n2);
            this.Xread += n2;
            if (bl && (n6 += n2) == n4) {
                n = this.Xread - this.Xoff;
                for (n9 = 0; n9 < this.Xoff; ++n9) {
                    this.X[this.Xread + n9] = 0.0f;
                }
            } else {
                n = this.Xread - 2 * this.Xoff;
            }
            if (n <= 0) break;
            n9 = d >= 1.0 ? this.lrsSrcUp(this.X, this.Y, d, n, n5, f, fArray, fArray2, bl2) : this.lrsSrcUD(this.X, this.Y, d, n, n5, f, fArray, fArray2, bl2);
            this.Time -= (double)n;
            this.Xp += n;
            int n10 = (int)this.Time - this.Xoff;
            if (n10 != 0) {
                this.Time -= (double)n10;
                this.Xp += n10;
            }
            int n11 = this.Xread - (this.Xp - this.Xoff);
            for (n8 = 0; n8 < n11; ++n8) {
                this.X[n8] = this.X[n8 + (this.Xp - this.Xoff)];
            }
            this.Xread = n11;
            this.Xp = this.Xoff;
            this.Yp = n9;
            if (this.Yp == 0 || n3 - n7 <= 0) continue;
            n2 = Math.min(n3 - n7, this.Yp);
            sampleBuffers.consumeOutput(this.Y, 0, n2);
            n7 += n2;
            for (n8 = 0; n8 < this.Yp - n2; ++n8) {
                this.Y[n8] = this.Y[n8 + n2];
            }
            this.Yp -= n2;
        } while (this.Yp == 0);
        return n6 == 0 && n7 == 0;
    }

    public boolean process(double d, final FloatBuffer floatBuffer, boolean bl, final FloatBuffer floatBuffer2) {
        SampleBuffers sampleBuffers = new SampleBuffers(){

            @Override
            public int getInputBufferLength() {
                return floatBuffer.remaining();
            }

            @Override
            public int getOutputBufferLength() {
                return floatBuffer2.remaining();
            }

            @Override
            public void produceInput(float[] fArray, int n, int n2) {
                floatBuffer.get(fArray, n, n2);
            }

            @Override
            public void consumeOutput(float[] fArray, int n, int n2) {
                floatBuffer2.put(fArray, n, n2);
            }
        };
        return this.process(d, sampleBuffers, bl);
    }

    public Result process(double d, float[] fArray, int n, int n2, boolean bl, float[] fArray2, int n3, int n4) {
        FloatBuffer floatBuffer = FloatBuffer.wrap(fArray, n, n2);
        FloatBuffer floatBuffer2 = FloatBuffer.wrap(fArray2, n3, n4);
        this.process(d, floatBuffer, bl, floatBuffer2);
        return new Result(floatBuffer.position() - n, floatBuffer2.position() - n3);
    }

    private int lrsSrcUp(float[] fArray, float[] fArray2, double d, int n, int n2, float f, float[] fArray3, float[] fArray4, boolean bl) {
        double d2;
        float[] fArray5 = fArray;
        float[] fArray6 = fArray2;
        int n3 = 0;
        double d3 = 1.0 / d;
        double d4 = d2 + (double)n;
        for (d2 = this.Time; d2 < d4; d2 += d3) {
            double d5 = d2 - Math.floor(d2);
            double d6 = 1.0 - d5;
            int n4 = (int)d2;
            float f2 = FilterKit.lrsFilterUp(fArray3, fArray4, n2, bl, fArray5, n4++, d5, -1);
            f2 += FilterKit.lrsFilterUp(fArray3, fArray4, n2, bl, fArray5, n4, d6, 1);
            fArray6[n3++] = f2 *= f;
        }
        this.Time = d2;
        return n3;
    }

    private int lrsSrcUD(float[] fArray, float[] fArray2, double d, int n, int n2, float f, float[] fArray3, float[] fArray4, boolean bl) {
        double d2;
        float[] fArray5 = fArray;
        float[] fArray6 = fArray2;
        int n3 = 0;
        double d3 = 1.0 / d;
        double d4 = Math.min(4096.0, d * 4096.0);
        double d5 = d2 + (double)n;
        for (d2 = this.Time; d2 < d5; d2 += d3) {
            double d6 = d2 - Math.floor(d2);
            double d7 = 1.0 - d6;
            int n4 = (int)d2;
            float f2 = FilterKit.lrsFilterUD(fArray3, fArray4, n2, bl, fArray5, n4++, d6, -1, d4);
            f2 += FilterKit.lrsFilterUD(fArray3, fArray4, n2, bl, fArray5, n4, d7, 1, d4);
            fArray6[n3++] = f2 *= f;
        }
        this.Time = d2;
        return n3;
    }

    public static class Result {
        public final int inputSamplesConsumed;
        public final int outputSamplesGenerated;

        public Result(int n, int n2) {
            this.inputSamplesConsumed = n;
            this.outputSamplesGenerated = n2;
        }
    }
}

