/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.resample;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class SoundTouchRateTransposer
implements AudioProcessor {
    private double rate;
    int slopeCount;
    double prevSample;
    private AudioDispatcher dispatcher;

    public void setDispatcher(AudioDispatcher audioDispatcher) {
        this.dispatcher = audioDispatcher;
    }

    public SoundTouchRateTransposer(double d) {
        this.rate = d;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        float[] fArray2 = new float[(int)Math.round((double)audioEvent.getBufferSize() / this.rate)];
        int n = 0;
        int n2 = 0;
        while ((float)this.slopeCount <= 1.0f) {
            fArray2[n2] = (float)((double)(1.0f - (float)this.slopeCount) * this.prevSample + (double)((float)this.slopeCount * fArray[0]));
            ++n2;
            this.slopeCount = (int)((double)this.slopeCount + this.rate);
        }
        this.slopeCount = (int)((float)this.slopeCount - 1.0f);
        while (true) {
            if ((float)this.slopeCount > 1.0f) {
                this.slopeCount = (int)((float)this.slopeCount - 1.0f);
                if (++n < fArray.length - 1) continue;
                break;
            }
            if (n2 < fArray2.length) {
                fArray2[n2] = (1.0f - (float)this.slopeCount) * fArray[n] + (float)this.slopeCount * fArray[n + 1];
            }
            ++n2;
            this.slopeCount = (int)((double)this.slopeCount + this.rate);
        }
        this.prevSample = fArray[fArray.length - 1];
        this.dispatcher.setStepSizeAndOverlap(fArray2.length, 0);
        audioEvent.setFloatBuffer(fArray2);
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

