/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.synthesis;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class AmplitudeLFO
implements AudioProcessor {
    private double frequency;
    private double scaleParameter;
    private double phase;

    public AmplitudeLFO() {
        this(1.5, 0.75);
    }

    public AmplitudeLFO(double d, double d2) {
        this.frequency = d;
        this.scaleParameter = d2;
        this.phase = 0.0;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        double d = audioEvent.getSampleRate();
        double d2 = Math.PI * 2 * this.frequency;
        double d3 = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            d3 = (double)i / d;
            float f = (float)(this.scaleParameter * Math.sin(d2 * d3 + this.phase));
            fArray[i] = f * fArray[i];
        }
        this.phase = d2 * (double)fArray.length / d + this.phase;
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

