/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.synthesis;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.EnvelopeFollower;
import be.tarsos.dsp.pitch.PitchDetectionHandler;
import be.tarsos.dsp.pitch.PitchDetectionResult;
import java.util.Arrays;

public class PitchResyntheziser
implements PitchDetectionHandler {
    private double phase = 0.0;
    private double phaseFirst = 0.0;
    private double phaseSecond = 0.0;
    private double prevFrequency = 0.0;
    private float samplerate;
    private final EnvelopeFollower envelopeFollower;
    private boolean usePureSine;
    private boolean followEnvelope;
    private final double[] previousFrequencies;
    private int previousFrequencyIndex;

    public PitchResyntheziser(float f) {
        this(f, true, false);
    }

    public PitchResyntheziser(float f, boolean bl, boolean bl2) {
        this(f, bl, bl2, 5);
    }

    public PitchResyntheziser(float f, boolean bl, boolean bl2, int n) {
        this.envelopeFollower = new EnvelopeFollower(f, 0.005, 0.01);
        this.followEnvelope = bl;
        this.usePureSine = bl2;
        this.samplerate = f;
        this.previousFrequencies = new double[n];
        this.previousFrequencyIndex = 0;
    }

    @Override
    public void handlePitch(PitchDetectionResult pitchDetectionResult, AudioEvent audioEvent) {
        double d = pitchDetectionResult.getPitch();
        if (d == -1.0) {
            d = this.prevFrequency;
        } else {
            if (this.previousFrequencies.length != 0) {
                this.previousFrequencies[this.previousFrequencyIndex] = d;
                ++this.previousFrequencyIndex;
                this.previousFrequencyIndex %= this.previousFrequencies.length;
                double[] dArray = (double[])this.previousFrequencies.clone();
                Arrays.sort(dArray);
                d = dArray[dArray.length / 2];
            }
            this.prevFrequency = d;
        }
        double d2 = Math.PI * 2 * d;
        float[] fArray = audioEvent.getFloatBuffer();
        float[] fArray2 = null;
        if (this.followEnvelope) {
            fArray2 = (float[])fArray.clone();
            this.envelopeFollower.calculateEnvelope(fArray2);
        }
        for (int i = 0; i < fArray.length; ++i) {
            double d3 = (float)i / this.samplerate;
            double d4 = Math.sin(d2 * d3 + this.phase);
            if (!this.usePureSine) {
                d4 += 0.05 * Math.sin(d2 * 4.0 * d3 + this.phaseFirst);
                d4 += 0.01 * Math.sin(d2 * 8.0 * d3 + this.phaseSecond);
            }
            fArray[i] = (float)d4;
            if (!this.followEnvelope) continue;
            fArray[i] = fArray[i] * fArray2[i];
        }
        double d5 = d2 * (double)fArray.length / (double)this.samplerate;
        this.phase = d5 + this.phase;
        if (!this.usePureSine) {
            this.phaseFirst = 4.0 * d5 + this.phaseFirst;
            this.phaseSecond = 8.0 * d5 + this.phaseSecond;
        }
    }
}

