/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.synthesis;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class SineGenerator
implements AudioProcessor {
    private double gain;
    private double frequency;
    private double phase;

    public SineGenerator() {
        this(1.0, 440.0);
    }

    public SineGenerator(double d, double d2) {
        this.gain = d;
        this.frequency = d2;
        this.phase = 0.0;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        double d = audioEvent.getSampleRate();
        double d2 = Math.PI * 2 * this.frequency;
        double d3 = 0.0;
        int n = 0;
        while (n < fArray.length) {
            d3 = (double)n / d;
            int n2 = n++;
            fArray[n2] = fArray[n2] + (float)(this.gain * Math.sin(d2 * d3 + this.phase));
        }
        this.phase = d2 * (double)fArray.length / d + this.phase;
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

