/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.AxisUnit;

public class CoordinateSystem {
    private final AxisUnit xAxisUnits;
    private final AxisUnit yAxisUnits;
    private float xMin = 0.0f;
    private float xMax = 10000.0f;
    private float yMin;
    private float yMax;
    private final boolean wraps;
    private float wrappingOrigin;
    private double startX = Double.MAX_VALUE;
    private double startY = Double.MAX_VALUE;
    private double endX = Double.MAX_VALUE;
    private double endY = Double.MAX_VALUE;

    public CoordinateSystem(AxisUnit axisUnit, float f, float f2) {
        this(AxisUnit.TIME, axisUnit, f, f2, false);
    }

    public CoordinateSystem(AxisUnit axisUnit, float f, float f2, boolean bl) {
        this(AxisUnit.TIME, axisUnit, f, f2, bl);
    }

    public CoordinateSystem(AxisUnit axisUnit, AxisUnit axisUnit2, float f, float f2, boolean bl) {
        this.yAxisUnits = axisUnit2;
        this.xAxisUnits = axisUnit;
        this.yMin = f;
        this.yMax = f2;
        this.wraps = bl;
        this.wrappingOrigin = 0.0f;
    }

    public float getWrappingOrigin() {
        return this.wrappingOrigin;
    }

    public void setWrappingOrigin(float f) {
        this.wrappingOrigin = f;
    }

    public float getRealXValue(float f) {
        float f2 = this.isWrapping() ? (1000.0f * this.getDelta(Axis.X) + f + this.getWrappingOrigin()) % this.getDelta(Axis.X) : f;
        return f2;
    }

    public float getDelta(Axis axis) {
        float f = axis == Axis.X ? this.xMax - this.xMin : this.yMax - this.yMin;
        return f;
    }

    public AxisUnit getUnitsForAxis(Axis axis) {
        AxisUnit axisUnit = axis == Axis.X ? this.xAxisUnits : this.yAxisUnits;
        return axisUnit;
    }

    public float getMin(Axis axis) {
        float f = axis == Axis.X ? this.xMin : this.yMin;
        return f;
    }

    public float getMax(Axis axis) {
        float f = axis == Axis.X ? this.xMax : this.yMax;
        return f;
    }

    public void setMax(Axis axis, float f) {
        if (axis == Axis.X) {
            this.xMax = f;
        } else {
            this.yMax = f;
        }
    }

    public void setMin(Axis axis, float f) {
        if (axis == Axis.X) {
            this.xMin = f;
        } else {
            this.yMin = f;
        }
    }

    public void setStartPoint(double d, double d2) {
        this.startX = d;
        this.startY = d2;
    }

    public boolean hasStartPoint() {
        return this.startX != Double.MAX_VALUE;
    }

    public void setEndPoint(double d, double d2) {
        this.endX = d;
        this.endY = d2;
    }

    public void clearPoints() {
        this.startX = Double.MAX_VALUE;
        this.startY = Double.MAX_VALUE;
        this.endX = Double.MAX_VALUE;
        this.endY = Double.MAX_VALUE;
    }

    public double getStartX() {
        return this.startX;
    }

    public double getStartY() {
        return this.startY;
    }

    public double getEndY() {
        return this.endY;
    }

    public double getEndX() {
        return this.endX;
    }

    public boolean isWrapping() {
        return this.wraps;
    }
}

