/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.AxisUnit;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.LinkedPanel;
import be.tarsos.dsp.ui.ViewPort;
import be.tarsos.dsp.ui.layers.AmplitudeAxisLayer;
import be.tarsos.dsp.ui.layers.BackgroundLayer;
import be.tarsos.dsp.ui.layers.BeatLayer;
import be.tarsos.dsp.ui.layers.ConstantQLayer;
import be.tarsos.dsp.ui.layers.DragMouseListenerLayer;
import be.tarsos.dsp.ui.layers.LegendLayer;
import be.tarsos.dsp.ui.layers.PitchContourLayer;
import be.tarsos.dsp.ui.layers.SelectionLayer;
import be.tarsos.dsp.ui.layers.TimeAxisLayer;
import be.tarsos.dsp.ui.layers.VerticalFrequencyAxisLayer;
import be.tarsos.dsp.ui.layers.WaveFormLayer;
import be.tarsos.dsp.ui.layers.ZoomMouseListenerLayer;
import be.tarsos.dsp.ui.layers.pch.PitchClassHistogramLayer;
import be.tarsos.dsp.ui.layers.pch.ScaleLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JSplitPane;

public class LinkedFrame
extends JFrame
implements ViewPort.ViewPortChangedListener {
    private JSplitPane lastSplitPane;
    private static final long serialVersionUID = 7301610309790983406L;
    private static LinkedFrame instance;
    private static HashMap<String, LinkedPanel> panels;
    private boolean drawing = false;

    public static void main(String ... stringArray) {
        LinkedFrame.getInstance();
    }

    protected JSplitPane getLastSplitPane() {
        return this.lastSplitPane;
    }

    private LinkedFrame() {
        panels = new HashMap();
    }

    public static LinkedFrame getInstance() {
        if (instance == null) {
            instance = new LinkedFrame();
            instance.initialise();
        }
        return instance;
    }

    public void initialise() {
        JSplitPane jSplitPane;
        this.setMinimumSize(new Dimension(800, 400));
        this.lastSplitPane = jSplitPane = new JSplitPane(0);
        this.setContentPane(jSplitPane);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.pack();
        jSplitPane.setDividerLocation(0);
        this.buildStdSetUp();
        this.setVisible(true);
    }

    public void createNewSplitPane() {
        this.lastSplitPane.setDividerSize(2);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setDividerSize(0);
        this.lastSplitPane.add((Component)jSplitPane, "bottom");
        this.lastSplitPane = jSplitPane;
    }

    @Override
    public void viewPortChanged(ViewPort viewPort) {
        if (!this.drawing) {
            this.drawing = true;
            for (LinkedPanel linkedPanel : panels.values()) {
                linkedPanel.repaint();
            }
            this.drawing = false;
        }
    }

    private CoordinateSystem getCoordinateSystem(AxisUnit axisUnit) {
        float f = -1000.0f;
        float f2 = 1000.0f;
        if (axisUnit == AxisUnit.FREQUENCY) {
            f = 200.0f;
            f2 = 8000.0f;
        }
        return new CoordinateSystem(axisUnit, f, f2);
    }

    private void buildStdSetUp() {
        CoordinateSystem coordinateSystem = this.getCoordinateSystem(AxisUnit.AMPLITUDE);
        File file = new File("/home/joren/Desktop/08._Ladrang_Kandamanyura_10s-20s.wav");
        LinkedPanel linkedPanel = new LinkedPanel(coordinateSystem);
        linkedPanel.addLayer(new ZoomMouseListenerLayer());
        linkedPanel.addLayer(new DragMouseListenerLayer(coordinateSystem));
        linkedPanel.addLayer(new BackgroundLayer(coordinateSystem));
        linkedPanel.addLayer(new AmplitudeAxisLayer(coordinateSystem));
        linkedPanel.addLayer(new TimeAxisLayer(coordinateSystem));
        linkedPanel.addLayer(new WaveFormLayer(coordinateSystem, file));
        linkedPanel.addLayer(new BeatLayer(coordinateSystem, file, true, true));
        linkedPanel.addLayer(new SelectionLayer(coordinateSystem));
        LegendLayer legendLayer = new LegendLayer(coordinateSystem, 50);
        linkedPanel.addLayer(legendLayer);
        legendLayer.addEntry("Onsets", Color.BLUE);
        legendLayer.addEntry("Beats", Color.RED);
        linkedPanel.getViewPort().addViewPortChangedListener(this);
        panels.put("Waveform", linkedPanel);
        this.lastSplitPane.add((Component)linkedPanel, "top");
        coordinateSystem = this.getCoordinateSystem(AxisUnit.FREQUENCY);
        linkedPanel = new LinkedPanel(coordinateSystem);
        linkedPanel.addLayer(new ZoomMouseListenerLayer());
        linkedPanel.addLayer(new DragMouseListenerLayer(coordinateSystem));
        linkedPanel.addLayer(new BackgroundLayer(coordinateSystem));
        linkedPanel.addLayer(new ConstantQLayer(coordinateSystem, file, 2048, 3600, 10800, 12));
        linkedPanel.addLayer(new PitchContourLayer(coordinateSystem, file, Color.red, 2048, 1024));
        linkedPanel.addLayer(new SelectionLayer(coordinateSystem));
        linkedPanel.addLayer(new VerticalFrequencyAxisLayer(coordinateSystem));
        linkedPanel.addLayer(new TimeAxisLayer(coordinateSystem));
        linkedPanel.getViewPort().addViewPortChangedListener(this);
        CoordinateSystem coordinateSystem2 = new CoordinateSystem(AxisUnit.OCCURENCES, 0.0f, 1000.0f, true);
        coordinateSystem2.setMin(Axis.X, 0.0f);
        coordinateSystem2.setMax(Axis.X, 1200.0f);
        final LinkedPanel linkedPanel2 = new LinkedPanel(coordinateSystem2);
        linkedPanel2.addLayer(new BackgroundLayer(coordinateSystem2));
        linkedPanel2.addLayer(new DragMouseListenerLayer(coordinateSystem2));
        linkedPanel2.addLayer(new PitchClassHistogramLayer());
        linkedPanel2.addLayer(new ScaleLayer(coordinateSystem2, true));
        linkedPanel2.addLayer(new ScaleLayer(coordinateSystem2, false));
        linkedPanel2.getViewPort().addViewPortChangedListener(new ViewPort.ViewPortChangedListener(){
            boolean painting = false;

            @Override
            public void viewPortChanged(ViewPort viewPort) {
                if (!this.painting) {
                    this.painting = true;
                    linkedPanel2.repaint();
                    this.painting = false;
                }
            }
        });
        this.lastSplitPane.add((Component)linkedPanel2, "bottom");
        panels.put("Spectral info", linkedPanel);
        this.lastSplitPane.setDividerLocation(0.7);
    }
}

