/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.ViewPort;
import be.tarsos.dsp.ui.layers.Layer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class LinkedPanel
extends JPanel {
    private static final long serialVersionUID = -5055686566048886896L;
    private List<Layer> layers;
    private final ViewPort viewPort;
    private CoordinateSystem cs;

    public LinkedPanel(CoordinateSystem coordinateSystem) {
        this.setFocusable(true);
        this.layers = new ArrayList<Layer>();
        this.cs = coordinateSystem;
        this.viewPort = new ViewPort(this.cs);
        this.setVisible(true);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LinkedPanel.this.transferFocusBackward();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LinkedPanel.this.requestFocus();
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }
        });
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.cs;
    }

    public ViewPort getViewPort() {
        return this.viewPort;
    }

    public void addLayer(Layer layer) {
        this.layers.add(layer);
        if (layer instanceof MouseMotionListener) {
            this.addMouseMotionListener((MouseMotionListener)((Object)layer));
        }
        if (layer instanceof MouseListener) {
            this.addMouseListener((MouseListener)((Object)layer));
        }
        if (layer instanceof MouseWheelListener) {
            this.addMouseWheelListener((MouseWheelListener)((Object)layer));
        }
        if (layer instanceof KeyListener) {
            this.addKeyListener((KeyListener)((Object)layer));
        }
    }

    public AffineTransform getTransform() {
        double d = this.cs.getDelta(Axis.X);
        double d2 = this.cs.getDelta(Axis.Y);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(0.0, this.getHeight());
        affineTransform.scale((double)this.getWidth() / d, (double)(-this.getHeight()) / d2);
        affineTransform.translate(-this.cs.getMin(Axis.X), -this.cs.getMin(Axis.Y));
        return affineTransform;
    }

    public AffineTransform updateTransform(AffineTransform affineTransform) {
        double d = this.cs.getDelta(Axis.X);
        double d2 = this.cs.getDelta(Axis.Y);
        affineTransform.translate(0.0, this.getHeight());
        affineTransform.scale((double)this.getWidth() / d, (double)(-this.getHeight()) / d2);
        affineTransform.translate(-this.cs.getMin(Axis.X), -this.cs.getMin(Axis.Y));
        return affineTransform;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setTransform(this.updateTransform(graphics2D.getTransform()));
        if (!this.layers.isEmpty()) {
            for (Layer layer : this.layers) {
                layer.draw(graphics2D);
            }
        }
    }

    public void removeLayer(Layer layer) {
        this.layers.remove(layer);
        if (layer instanceof MouseMotionListener) {
            this.removeMouseMotionListener((MouseMotionListener)((Object)layer));
        }
        if (layer instanceof MouseListener) {
            this.removeMouseListener((MouseListener)((Object)layer));
        }
        if (layer instanceof MouseWheelListener) {
            this.removeMouseWheelListener((MouseWheelListener)((Object)layer));
        }
        if (layer instanceof KeyListener) {
            this.removeKeyListener((KeyListener)((Object)layer));
        }
    }

    public void removeLayers() {
        while (this.layers.size() > 0) {
            this.removeLayer(this.layers.get(0));
        }
    }
}

