/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.AxisUnit;
import be.tarsos.dsp.ui.CoordinateSystem;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class ViewPort {
    private final List<ViewPortChangedListener> listeners;
    private final CoordinateSystem cs;
    private int xMinPref = Integer.MAX_VALUE;
    private int xMaxPref = Integer.MAX_VALUE;
    private int yMinPref = Integer.MAX_VALUE;
    private int yMaxPref = Integer.MAX_VALUE;
    private boolean onlyZoomXWithMouseWheel = false;

    public ViewPort(CoordinateSystem coordinateSystem) {
        this.listeners = new ArrayList<ViewPortChangedListener>();
        this.cs = coordinateSystem;
    }

    public void addViewPortChangedListener(ViewPortChangedListener viewPortChangedListener) {
        this.listeners.add(viewPortChangedListener);
    }

    private void viewPortChanged() {
        for (ViewPortChangedListener viewPortChangedListener : this.listeners) {
            viewPortChangedListener.viewPortChanged(this);
        }
    }

    public void setPreferredZoomWindow(int n, int n2, int n3, int n4) {
        this.xMinPref = n;
        this.xMaxPref = n2;
        this.yMinPref = n3;
        this.yMaxPref = n4;
    }

    public void setOnlyZoomXAxisWithMouseWheel(boolean bl) {
        this.onlyZoomXWithMouseWheel = bl;
    }

    public void zoom(int n, Point point) {
        float f;
        float f2;
        float f3 = this.cs.getDelta(Axis.X);
        float f4 = f3 + (float)(n * 1000);
        if (f4 > 2.0f && f4 < 600000.0f) {
            this.cs.setMax(Axis.X, this.cs.getMin(Axis.X) + f4);
        }
        if (this.cs.getUnitsForAxis(Axis.Y) == AxisUnit.FREQUENCY && !this.onlyZoomXWithMouseWheel && (f2 = (f = this.cs.getDelta(Axis.Y)) + (float)(n * 10)) > 50.0f && f4 < 150000.0f) {
            this.cs.setMax(Axis.Y, this.cs.getMin(Axis.Y) + f2);
        }
        this.viewPortChanged();
    }

    public void resetZoom() {
        if (this.xMinPref != Integer.MAX_VALUE) {
            this.cs.setMin(Axis.X, this.xMinPref);
            this.cs.setMax(Axis.X, this.xMaxPref);
        }
        if (this.yMinPref != Integer.MAX_VALUE) {
            this.cs.setMin(Axis.Y, this.yMinPref);
            this.cs.setMax(Axis.Y, this.yMaxPref);
        }
        if (this.xMinPref == Integer.MAX_VALUE && this.yMinPref == Integer.MAX_VALUE) {
            if (this.cs.getUnitsForAxis(Axis.Y) == AxisUnit.FREQUENCY) {
                this.cs.setMin(Axis.Y, 3600.0f);
                this.cs.setMax(Axis.Y, 12800.0f);
            }
            this.cs.setMin(Axis.X, 0.0f);
            this.cs.setMax(Axis.X, 30000.0f);
        }
        this.viewPortChanged();
    }

    public void zoomToSelection() {
        double d;
        if (!this.cs.hasStartPoint() || this.cs.getEndX() == Double.MAX_VALUE) {
            this.cs.clearPoints();
            return;
        }
        double d2 = this.cs.getStartX();
        double d3 = this.cs.getStartY();
        double d4 = this.cs.getEndX();
        double d5 = this.cs.getEndY();
        this.cs.clearPoints();
        if (d2 > d4) {
            d = d2;
            d2 = d4;
            d4 = d;
        }
        if (d3 > d5) {
            d = d3;
            d3 = d5;
            d5 = d;
        }
        int n = 10;
        int n2 = 50;
        if (d4 - d2 <= (double)n) {
            d4 = d2 + (double)n;
        }
        if (d5 - d3 <= (double)n2) {
            d5 = d3 + (double)n2;
        }
        this.cs.setMin(Axis.X, (float)d2);
        this.cs.setMax(Axis.X, (float)d4);
        if (this.cs.getUnitsForAxis(Axis.Y) == AxisUnit.FREQUENCY) {
            this.cs.setMin(Axis.Y, (float)d3);
            this.cs.setMax(Axis.Y, (float)d5);
        }
        this.viewPortChanged();
    }

    public void drag(float f, float f2) {
        this.cs.setMin(Axis.X, this.cs.getMin(Axis.X) + f);
        this.cs.setMax(Axis.X, this.cs.getMax(Axis.X) + f);
        this.cs.setMin(Axis.Y, this.cs.getMin(Axis.Y) + f2);
        this.cs.setMax(Axis.Y, this.cs.getMax(Axis.Y) + f2);
        this.viewPortChanged();
    }

    public static interface ViewPortChangedListener {
        public void viewPortChanged(ViewPort var1);
    }
}

