/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.AxisUnit;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;

public class AmplitudeAxisLayer
implements Layer {
    CoordinateSystem cs;

    public AmplitudeAxisLayer(CoordinateSystem coordinateSystem) {
        this.cs = coordinateSystem;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.cs.getUnitsForAxis(Axis.Y) == AxisUnit.AMPLITUDE) {
            this.drawAmplitudeXAxis(graphics2D);
        }
    }

    public void drawAmplitudeXAxis(Graphics2D graphics2D) {
        graphics2D.setColor(Color.black);
        int n = Math.round(this.cs.getMin(Axis.X));
        int n2 = Math.round(this.cs.getMax(Axis.Y));
        int n3 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 4, true));
        int n4 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 14, true));
        int n5 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 20, false));
        int n6 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 2, true));
        int n7 = (int)this.cs.getMin(Axis.Y);
        while ((float)n7 < this.cs.getMax(Axis.Y)) {
            if (n7 % 100 == 0) {
                graphics2D.drawLine(n, n7, n + n3, n7);
                String string = String.format("%.0f", (double)n7 / 10.0);
                LayerUtilities.drawString(graphics2D, string, n + n4, n7, true, true, null);
            } else if (n7 % 10 == 0) {
                graphics2D.drawLine(n, n7, n + n6, n7);
            }
            ++n7;
        }
        graphics2D.drawLine(n, 0, n, n2);
        LayerUtilities.drawString(graphics2D, "Amplitude (%)", n + n4, n2 - n5, false, true, Color.white);
    }

    @Override
    public String getName() {
        return "Amplitude Axis";
    }
}

