/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import java.awt.Color;
import java.awt.Graphics2D;

public class BackgroundLayer
implements Layer {
    private final CoordinateSystem cs;
    private final Color color;

    public BackgroundLayer(CoordinateSystem coordinateSystem) {
        this(coordinateSystem, Color.WHITE);
    }

    public BackgroundLayer(CoordinateSystem coordinateSystem, Color color) {
        this.cs = coordinateSystem;
        this.color = color;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        graphics2D.setColor(this.color);
        graphics2D.fillRect(Math.round(this.cs.getMin(Axis.X)), Math.round(this.cs.getMin(Axis.Y)), Math.round(this.cs.getDelta(Axis.X)), Math.round(this.cs.getDelta(Axis.Y)));
    }

    @Override
    public String getName() {
        return "Background layer";
    }
}

