/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.beatroot.BeatRootOnsetEventHandler;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.onsets.ComplexOnsetDetector;
import be.tarsos.dsp.onsets.OnsetHandler;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.UnsupportedAudioFileException;

public class BeatLayer
implements Layer {
    private final List<Double> onsets = new ArrayList<Double>();
    private final List<Double> beats = new ArrayList<Double>();
    private final CoordinateSystem cs;
    private final Color onsetColor;
    private final Color beatColor;
    private final int frameSize;
    private final int overlap;
    private final File audioFile;
    private final boolean showBeats;
    private final boolean showOnsets;

    public BeatLayer(CoordinateSystem coordinateSystem, File file, boolean bl, boolean bl2) {
        this.cs = coordinateSystem;
        this.frameSize = 256;
        this.overlap = 0;
        this.onsetColor = Color.blue;
        this.beatColor = Color.red;
        this.showBeats = bl;
        this.showOnsets = bl2;
        this.audioFile = file;
        this.initialise();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        int n;
        int n2 = Math.round(this.cs.getMax(Axis.Y));
        int n3 = Math.round(this.cs.getMin(Axis.Y));
        if (!this.onsets.isEmpty() && this.showOnsets) {
            graphics2D.setColor(this.onsetColor);
            for (Double d : this.onsets) {
                n = (int)Math.round(d * 1000.0);
                graphics2D.drawLine(n, n3, n, n2);
            }
        }
        if (!this.beats.isEmpty() && this.showBeats) {
            graphics2D.setColor(this.beatColor);
            for (Double d : this.beats) {
                n = (int)Math.round(d * 1000.0);
                graphics2D.drawLine(n, n3, n, n2);
            }
        }
    }

    public void initialise() {
        try {
            AudioDispatcher audioDispatcher = AudioDispatcherFactory.fromFile(this.audioFile, this.frameSize, this.overlap);
            float f = audioDispatcher.getFormat().getSampleRate();
            final double d = (double)((float)this.frameSize / f) / 2.0;
            ComplexOnsetDetector complexOnsetDetector = new ComplexOnsetDetector(this.frameSize);
            final BeatRootOnsetEventHandler beatRootOnsetEventHandler = new BeatRootOnsetEventHandler();
            audioDispatcher.addAudioProcessor(complexOnsetDetector);
            audioDispatcher.addAudioProcessor(new AudioProcessor(){

                @Override
                public void processingFinished() {
                    beatRootOnsetEventHandler.trackBeats(new OnsetHandler(){

                        @Override
                        public void handleOnset(double d, double d2) {
                            BeatLayer.this.beats.add(d - d);
                        }
                    });
                }

                @Override
                public boolean process(AudioEvent audioEvent) {
                    return true;
                }
            });
            complexOnsetDetector.setHandler(new OnsetHandler(){

                @Override
                public void handleOnset(double d3, double d2) {
                    BeatLayer.this.onsets.add(d3 - d);
                    beatRootOnsetEventHandler.handleOnset(d3 - d, d2);
                }
            });
            new Thread(audioDispatcher).start();
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            unsupportedAudioFileException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "Beats Layer";
    }
}

