/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.ConstantQ;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.util.PitchConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ConstantQLayer
implements Layer,
Runnable {
    private TreeMap<Double, float[]> features;
    private final CoordinateSystem cs;
    private final File audioFile;
    private float maxSpectralEnergy = 0.0f;
    private float minSpectralEnergy = 100000.0f;
    private float[] binStartingPointsInCents;
    private float binWith;
    private float binHeight;
    private int minimumFrequencyInCents = 4000;
    private int maximumFrequencyInCents = 10500;
    private int binsPerOctave = 48;
    private int increment;

    public ConstantQLayer(CoordinateSystem coordinateSystem, File file, int n, int n2, int n3, int n4) {
        this.cs = coordinateSystem;
        this.audioFile = file;
        this.increment = n;
        this.minimumFrequencyInCents = n2;
        this.maximumFrequencyInCents = n3;
        new Thread((Runnable)this, "Constant Q Initialization").start();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.features != null) {
            SortedMap<Double, float[]> sortedMap = this.features.subMap((double)this.cs.getMin(Axis.X) / 1000.0, (double)this.cs.getMax(Axis.X) / 1000.0);
            double d = 0.0;
            for (Map.Entry entry : sortedMap.entrySet()) {
                float[] fArray = (float[])entry.getValue();
                for (int i = 0; i < fArray.length; ++i) {
                    d = Math.max(d, (double)fArray[i]);
                }
            }
            for (Map.Entry entry : sortedMap.entrySet()) {
                double d2 = (Double)entry.getKey();
                float[] fArray = (float[])entry.getValue();
                for (int i = 0; i < fArray.length; ++i) {
                    Color color = Color.black;
                    float f = this.binStartingPointsInCents[i];
                    if (!(f >= this.cs.getMin(Axis.Y)) || !(f <= this.cs.getMax(Axis.Y))) continue;
                    int n = 255 - (int)(Math.log1p(fArray[i]) / Math.log1p(d) * 255.0);
                    n = Math.max(0, n);
                    color = new Color(n, n, n);
                    graphics2D.setColor(color);
                    graphics2D.fillRect((int)Math.round(d2 * 1000.0), Math.round(f), Math.round(this.binWith * 1000.0f), (int)Math.ceil(this.binHeight));
                }
            }
        }
    }

    @Override
    public void run() {
        try {
            int n;
            float f = (float)PitchConverter.absoluteCentToHertz(this.minimumFrequencyInCents);
            float f2 = (float)PitchConverter.absoluteCentToHertz(this.maximumFrequencyInCents);
            float f3 = AudioDispatcherFactory.fromFile(this.audioFile, 2048, 0).getFormat().getFrameRate();
            final ConstantQ constantQ = new ConstantQ(f3, f, f2, this.binsPerOctave);
            this.binWith = (float)this.increment / f3;
            this.binHeight = 1200.0f / (float)this.binsPerOctave;
            float[] fArray = constantQ.getFreqencies();
            this.binStartingPointsInCents = new float[fArray.length];
            for (n = 0; n < this.binStartingPointsInCents.length; ++n) {
                this.binStartingPointsInCents[n] = (float)PitchConverter.hertzToAbsoluteCent(fArray[n]);
            }
            n = constantQ.getFFTlength();
            AudioDispatcher audioDispatcher = AudioDispatcherFactory.fromFile(this.audioFile, n, n - this.increment);
            final double d = (double)((float)n / audioDispatcher.getFormat().getSampleRate()) - (double)this.binWith / 2.0;
            final TreeMap treeMap = new TreeMap();
            audioDispatcher.addAudioProcessor(constantQ);
            audioDispatcher.addAudioProcessor(new AudioProcessor(){

                @Override
                public void processingFinished() {
                    float f = 5.0E-6f;
                    for (float[] fArray : treeMap.values()) {
                        for (int i = 0; i < fArray.length; ++i) {
                            fArray[i] = Math.max(f, fArray[i]);
                            fArray[i] = (float)Math.log1p(fArray[i]);
                            ConstantQLayer.this.maxSpectralEnergy = Math.max(fArray[i], ConstantQLayer.this.maxSpectralEnergy);
                            ConstantQLayer.this.minSpectralEnergy = Math.min(fArray[i], ConstantQLayer.this.minSpectralEnergy);
                        }
                    }
                    ConstantQLayer.this.minSpectralEnergy = Math.abs(ConstantQLayer.this.minSpectralEnergy);
                    ConstantQLayer.this.features = treeMap;
                }

                @Override
                public boolean process(AudioEvent audioEvent) {
                    treeMap.put(audioEvent.getTimeStamp() - d, constantQ.getMagnitudes().clone());
                    return true;
                }
            });
            new Thread((Runnable)audioDispatcher, "Constant Q Calculation").start();
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            unsupportedAudioFileException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "Constant-Q Layer";
    }
}

