/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.LinkedPanel;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class DragMouseListenerLayer
extends MouseAdapter
implements Layer {
    private final boolean onlyHorizontal;
    private Point previousPoint;
    private final CoordinateSystem cs;

    public DragMouseListenerLayer(CoordinateSystem coordinateSystem) {
        this.onlyHorizontal = coordinateSystem.isWrapping();
        this.previousPoint = null;
        this.cs = coordinateSystem;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
    }

    @Override
    public String getName() {
        return "Listen to drag events.";
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.previousPoint = mouseEvent.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.previousPoint = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent) && this.previousPoint != null) {
            if (this.onlyHorizontal) {
                this.dragHorizontally(mouseEvent);
            } else {
                this.dragBoth(mouseEvent);
            }
        }
    }

    private void dragBoth(MouseEvent mouseEvent) {
        LinkedPanel linkedPanel = (LinkedPanel)mouseEvent.getComponent();
        Graphics2D graphics2D = (Graphics2D)linkedPanel.getGraphics();
        graphics2D.setTransform(linkedPanel.getTransform());
        Point2D point2D = LayerUtilities.pixelsToUnits(graphics2D, mouseEvent.getX(), mouseEvent.getY());
        Point2D point2D2 = LayerUtilities.pixelsToUnits(graphics2D, (int)this.previousPoint.getX(), (int)this.previousPoint.getY());
        float f = (float)(point2D2.getX() - point2D.getX());
        float f2 = (float)(point2D2.getY() - point2D.getY());
        this.previousPoint = mouseEvent.getPoint();
        linkedPanel.getViewPort().drag(f, f2);
        graphics2D.dispose();
    }

    private void dragHorizontally(MouseEvent mouseEvent) {
        LinkedPanel linkedPanel = (LinkedPanel)mouseEvent.getComponent();
        Graphics2D graphics2D = (Graphics2D)linkedPanel.getGraphics();
        graphics2D.setTransform(linkedPanel.getTransform());
        Point2D point2D = LayerUtilities.pixelsToUnits(graphics2D, mouseEvent.getX(), (int)this.previousPoint.getY());
        Point2D point2D2 = LayerUtilities.pixelsToUnits(graphics2D, (int)this.previousPoint.getX(), (int)this.previousPoint.getY());
        float f = (float)(point2D2.getX() - point2D.getX());
        this.previousPoint = mouseEvent.getPoint();
        if (this.cs.isWrapping()) {
            this.cs.setWrappingOrigin(this.cs.getWrappingOrigin() + f);
            linkedPanel.getViewPort().drag(0.0f, 0.0f);
        } else {
            linkedPanel.getViewPort().drag(f, 0.0f);
        }
        graphics2D.dispose();
    }
}

