/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.TooltipLayer;
import be.tarsos.dsp.util.PitchConverter;
import be.tarsos.dsp.util.fft.FFT;
import be.tarsos.dsp.util.fft.HammingWindow;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.sound.sampled.UnsupportedAudioFileException;

public class FFTLayer
implements Layer,
TooltipLayer.TooltipTextGenerator {
    private TreeMap<Double, FFTFrame> features;
    private final CoordinateSystem cs;
    private final int frameSize;
    private final int overlap;
    private final File audioFile;
    private float binWith;
    private float maxSpectralEnergy = 0.0f;
    private float minSpectralEnergy = 100000.0f;
    private float[] binStartingPointsInCents;
    private float[] binHeightsInCents;
    private int increment;

    public FFTLayer(CoordinateSystem coordinateSystem, File file, int n, int n2) {
        this.increment = n - n2;
        this.features = new TreeMap();
        this.cs = coordinateSystem;
        this.audioFile = file;
        this.frameSize = n;
        this.overlap = n2;
        this.initialise();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.features != null) {
            SortedMap<Double, FFTFrame> sortedMap = this.features.subMap((double)this.cs.getMin(Axis.X) / 1000.0, (double)this.cs.getMax(Axis.X) / 1000.0);
            for (Map.Entry entry : sortedMap.entrySet()) {
                double d = (Double)entry.getKey();
                FFTFrame fFTFrame = (FFTFrame)entry.getValue();
                for (int i = 0; i < fFTFrame.magnitudes.length; ++i) {
                    Color color = Color.black;
                    float f = this.binStartingPointsInCents[i];
                    if (!(f >= this.cs.getMin(Axis.Y)) || !(f <= this.cs.getMax(Axis.Y))) continue;
                    float f2 = (fFTFrame.magnitudes[i] - fFTFrame.getMinMagnitude()) / (fFTFrame.getMaxMagnitude() - fFTFrame.getMinMagnitude());
                    int n = 255 - (int)(f2 * 255.0f);
                    n = Math.max(0, n);
                    color = new Color(n, n, n);
                    graphics2D.setColor(color);
                    graphics2D.fillRect((int)Math.round(d * 1000.0), Math.round(f), Math.round(this.binWith * 1000.0f), (int)Math.ceil(this.binHeightsInCents[i]));
                }
            }
        }
    }

    public void initialise() {
        try {
            AudioDispatcher audioDispatcher = AudioDispatcherFactory.fromFile(this.audioFile, this.frameSize, this.overlap);
            final float f = audioDispatcher.getFormat().getSampleRate();
            final TreeMap treeMap = new TreeMap();
            this.binWith = (float)this.increment / f;
            final FFT fFT = new FFT(this.frameSize, new HammingWindow());
            this.binStartingPointsInCents = new float[this.frameSize];
            this.binHeightsInCents = new float[this.frameSize];
            for (int i = 1; i < this.frameSize; ++i) {
                this.binStartingPointsInCents[i] = (float)PitchConverter.hertzToAbsoluteCent(fFT.binToHz(i, f));
                this.binHeightsInCents[i] = this.binStartingPointsInCents[i] - this.binStartingPointsInCents[i - 1];
            }
            final double d = (double)((float)this.frameSize / f) - (double)this.binWith / 2.0;
            audioDispatcher.addAudioProcessor(new AudioProcessor(){
                float[] previousPhaseOffsets = null;

                @Override
                public boolean process(AudioEvent audioEvent) {
                    float[] fArray = (float[])audioEvent.getFloatBuffer().clone();
                    float[] fArray2 = new float[fArray.length / 2];
                    float[] fArray3 = new float[fArray.length / 2];
                    fFT.powerPhaseFFT(fArray, fArray2, fArray3);
                    FFTFrame fFTFrame = new FFTFrame(fFT, FFTLayer.this.frameSize, FFTLayer.this.overlap, f, fArray2, fArray3, this.previousPhaseOffsets);
                    this.previousPhaseOffsets = fArray3;
                    treeMap.put(audioEvent.getTimeStamp() - d, fFTFrame);
                    return true;
                }

                @Override
                public void processingFinished() {
                    float f3 = 0.99f;
                    float f2 = 1.01f;
                    for (FFTFrame fFTFrame : treeMap.values()) {
                        FFTLayer.this.maxSpectralEnergy = Math.max(fFTFrame.calculateMaxMagnitude(), FFTLayer.this.maxSpectralEnergy);
                        fFTFrame.setMaxMagnitude(FFTLayer.this.maxSpectralEnergy);
                        FFTLayer.this.minSpectralEnergy = Math.min(fFTFrame.calculateMinMagnitude(), FFTLayer.this.minSpectralEnergy);
                        fFTFrame.setMinMagnitude(FFTLayer.this.minSpectralEnergy);
                        FFTLayer.this.maxSpectralEnergy = FFTLayer.this.maxSpectralEnergy * f3;
                        FFTLayer.this.minSpectralEnergy = FFTLayer.this.minSpectralEnergy * f2;
                    }
                    FFTLayer.this.features = treeMap;
                }
            });
            new Thread((Runnable)audioDispatcher, "Calculate FFT").start();
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            unsupportedAudioFileException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "FFT Layer";
    }

    @Override
    public String generateTooltip(CoordinateSystem coordinateSystem, Point2D point2D) {
        String string = "";
        if (this.features != null) {
            double d = point2D.getX() / 1000.0;
            Map.Entry<Double, FFTFrame> entry = this.features.ceilingEntry(d);
            Map.Entry<Double, FFTFrame> entry2 = this.features.floorEntry(d);
            double d2 = Math.abs(entry2.getKey() - d);
            double d3 = Math.abs(entry2.getKey() - d);
            Map.Entry<Double, FFTFrame> entry3 = d3 > d2 ? entry2 : entry;
            FFTFrame fFTFrame = entry3.getValue();
            int n = 0;
            for (int i = 0; i < this.binStartingPointsInCents.length; ++i) {
                if (!((double)this.binStartingPointsInCents[i] > point2D.getY()) || n != 0) continue;
                n = i - 1;
            }
            float f = fFTFrame.getFrequencyForBin(n);
            string = String.format("Bin: %d  Estimated Frequency: %.02fHz  Time: %.03fs  ", n, Float.valueOf(f), d);
        }
        return string;
    }

    private static class FFTFrame {
        private float[] magnitudes;
        private float[] currentPhaseOffsets;
        private float[] previousPhaseOffsets;
        private FFT fft;
        private float[] frequencyEstimates;
        private final double dt;
        private final double cbin;
        private final double inv_2pi;
        private final double inv_deltat;
        private final double inv_2pideltat;
        private float sampleRate;
        private float minMagnitude;
        private float maxMagnitude;

        public FFTFrame(FFT fFT, int n, int n2, float f, float[] fArray, float[] fArray2, float[] fArray3) {
            this.fft = fFT;
            this.magnitudes = fArray;
            this.currentPhaseOffsets = fArray2;
            this.previousPhaseOffsets = fArray3;
            this.frequencyEstimates = new float[fArray.length];
            this.dt = (double)(n - n2) / (double)f;
            this.cbin = this.dt * (double)f / (double)n;
            this.sampleRate = f;
            this.inv_2pi = 0.15915494309189535;
            this.inv_deltat = 1.0 / this.dt;
            this.inv_2pideltat = this.inv_deltat * this.inv_2pi;
            this.calculateFrequencyEstimates();
            this.convertMagnitudesToDecibel();
        }

        private void convertMagnitudesToDecibel() {
            float f = 5.0E-6f;
            for (int i = 0; i < this.magnitudes.length; ++i) {
                double d = 1.0f + this.magnitudes[i];
                if (d <= 0.0) {
                    d = 1.0f + f;
                }
                this.magnitudes[i] = (float)Math.abs(20.0 * Math.log10(d));
            }
        }

        private void calculateFrequencyEstimates() {
            for (int i = 0; i < this.frequencyEstimates.length; ++i) {
                this.frequencyEstimates[i] = this.getFrequencyForBin(i);
            }
        }

        public float calculateMinMagnitude() {
            float f = 4654654.0f;
            for (int i = 0; i < this.magnitudes.length; ++i) {
                f = Math.min(f, this.magnitudes[i]);
            }
            return f;
        }

        public float calculateMaxMagnitude() {
            float f = -1654654.0f;
            for (int i = 0; i < this.magnitudes.length; ++i) {
                f = Math.max(f, this.magnitudes[i]);
            }
            return f;
        }

        public float getMaxMagnitude() {
            return this.maxMagnitude;
        }

        public void setMaxMagnitude(float f) {
            this.maxMagnitude = f;
        }

        public float getMinMagnitude() {
            return this.minMagnitude;
        }

        public void setMinMagnitude(float f) {
            this.minMagnitude = f;
        }

        private float getFrequencyForBin(int n) {
            float f;
            if (this.previousPhaseOffsets != null) {
                float f2 = this.currentPhaseOffsets[n] - this.previousPhaseOffsets[n];
                long l = Math.round(this.cbin * (double)n - this.inv_2pi * (double)f2);
                f = (float)(this.inv_2pideltat * (double)f2 + this.inv_deltat * (double)l);
            } else {
                f = (float)this.fft.binToHz(n, this.sampleRate);
            }
            return f;
        }
    }
}

