/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.StopAudioProcessor;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.pitch.GeneralizedGoertzel;
import be.tarsos.dsp.pitch.Goertzel;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.util.PitchConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.sound.sampled.UnsupportedAudioFileException;

public class GeneralizedGoertzelLayer
implements Layer {
    private TreeMap<Double, double[]> features;
    private final CoordinateSystem cs;
    private final File audioFile;
    private double maxSpectralEnergy = 0.0;
    private double minSpectralEnergy = 100000.0;
    private float[] binStartingPointsInCents;
    private float binWith;
    private float binHeight;

    public GeneralizedGoertzelLayer(CoordinateSystem coordinateSystem, File file, int n) {
        this.cs = coordinateSystem;
        this.audioFile = file;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        this.calculateFeatures();
        if (this.features != null) {
            SortedMap<Double, double[]> sortedMap = this.features.subMap((double)this.cs.getMin(Axis.X) / 1000.0, (double)this.cs.getMax(Axis.X) / 1000.0);
            for (Map.Entry entry : sortedMap.entrySet()) {
                double d = (Double)entry.getKey();
                double[] dArray = (double[])entry.getValue();
                for (int i = 0; i < dArray.length; ++i) {
                    Color color = Color.black;
                    float f = this.binStartingPointsInCents[i];
                    if (!(f >= this.cs.getMin(Axis.Y)) || !(f <= this.cs.getMax(Axis.Y))) continue;
                    double d2 = dArray[i] / this.maxSpectralEnergy;
                    int n = 255 - (int)(d2 * 255.0);
                    n = Math.max(0, n);
                    color = new Color(n, n, n);
                    graphics2D.setColor(color);
                    graphics2D.fillRect((int)Math.round(d * 1000.0), Math.round(f), Math.round(this.binWith * 1000.0f), (int)Math.ceil(this.binHeight));
                }
            }
        }
    }

    public void calculateFeatures() {
        try {
            int n = 8000;
            int n2 = 7500;
            AudioDispatcher audioDispatcher = AudioDispatcherFactory.fromFile(this.audioFile, n, n2);
            audioDispatcher.skip(Math.max(0.0, (double)this.cs.getMin(Axis.X) / 1000.0));
            audioDispatcher.addAudioProcessor(new StopAudioProcessor((double)this.cs.getMax(Axis.X) / 1000.0));
            float f = audioDispatcher.getFormat().getFrameRate();
            double d = this.cs.getMin(Axis.Y);
            double d2 = this.cs.getMax(Axis.Y);
            int n3 = 50;
            double d3 = (d2 - d) / (double)n3;
            this.binWith = (float)(n - n2) / f;
            this.binHeight = (float)d3;
            double[] dArray = new double[n3];
            this.binStartingPointsInCents = new float[n3];
            for (int i = 0; i < n3; ++i) {
                double d4 = (double)i * d3 + d;
                dArray[i] = PitchConverter.absoluteCentToHertz(d4);
                this.binStartingPointsInCents[i] = (float)d4;
            }
            final TreeMap treeMap = new TreeMap();
            Goertzel.FrequenciesDetectedHandler frequenciesDetectedHandler = new Goertzel.FrequenciesDetectedHandler(){
                int i = 0;

                @Override
                public void handleDetectedFrequencies(double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
                    double d2 = Math.max(0.0, (double)GeneralizedGoertzelLayer.this.cs.getMin(Axis.X) / 1000.0) + (double)((float)this.i * GeneralizedGoertzelLayer.this.binWith);
                    ++this.i;
                    treeMap.put(d2, dArray4.clone());
                }
            };
            GeneralizedGoertzel generalizedGoertzel = new GeneralizedGoertzel(f, n, dArray, frequenciesDetectedHandler);
            audioDispatcher.addAudioProcessor(generalizedGoertzel);
            audioDispatcher.run();
            for (double[] dArray2 : treeMap.values()) {
                for (int i = 0; i < dArray2.length; ++i) {
                    if (dArray2[i] == 0.0) {
                        dArray2[i] = 1.0E-10;
                    }
                    dArray2[i] = 20.0 * Math.log(1.0 + Math.abs(dArray2[i])) / Math.log(10.0);
                    this.maxSpectralEnergy = Math.max(dArray2[i], this.maxSpectralEnergy);
                    this.minSpectralEnergy = Math.min(dArray2[i], this.minSpectralEnergy);
                }
            }
            this.minSpectralEnergy = Math.abs(this.minSpectralEnergy);
            this.features = treeMap;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            unsupportedAudioFileException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "Generalized Goertzel Layer";
    }
}

