/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;

public class HorizontalFrequencyAxisLayer
implements Layer {
    CoordinateSystem cs;

    public HorizontalFrequencyAxisLayer(CoordinateSystem coordinateSystem) {
        this.cs = coordinateSystem;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        graphics2D.setColor(Color.black);
        int n = Math.round(this.cs.getMin(Axis.Y) + 1.0f);
        int n2 = Math.round(this.cs.getMin(Axis.X));
        int n3 = Math.round(this.cs.getMax(Axis.X));
        int n4 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 8, false));
        int n5 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 6, false));
        int n6 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 2, false));
        int n7 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 12, false));
        int n8 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 120, true));
        float f = LayerUtilities.unitsToPixels(graphics2D, 100.0f, true);
        int n9 = (int)this.cs.getMin(Axis.X);
        while ((float)n9 < this.cs.getMax(Axis.X)) {
            if (n9 % 1200 == 0) {
                graphics2D.drawLine(n9, n, n9, n + n4);
                String string = String.valueOf(n9);
                LayerUtilities.drawString(graphics2D, string, n9, n + n7, true, false, null);
            } else if (n9 % 600 == 0) {
                graphics2D.drawLine(n9, n, n9, n + n5);
            } else if (f > 10.0f && n9 % 100 == 0) {
                graphics2D.drawLine(n9, n, n9, n + n6);
            }
            ++n9;
        }
        graphics2D.drawLine(n2, n, n3, n);
        LayerUtilities.drawString(graphics2D, "Frequency (cents)", n3 - n8, n + 4 * n4, false, true, Color.white);
    }

    @Override
    public String getName() {
        return "Frequency Axis";
    }
}

