/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LayerUtilities {
    private LayerUtilities() {
    }

    public static Point2D pixelsToUnits(Graphics2D graphics2D, int n, int n2) {
        Point2D point2D = null;
        try {
            point2D = graphics2D.getTransform().inverseTransform(new Point2D.Double(n, n2), null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        return point2D;
    }

    public static float pixelsToUnits(Graphics2D graphics2D, int n, boolean bl) {
        float f = 0.0f;
        try {
            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
            Point2D point2D = graphics2D.getTransform().inverseTransform(double_, null);
            Point2D.Double double_2 = new Point2D.Double(n, n);
            Point2D point2D2 = graphics2D.getTransform().inverseTransform(double_2, null);
            f = bl ? (float)(point2D2.getX() - point2D.getX()) : (float)(-point2D2.getY() + point2D.getY());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        return f;
    }

    public static float unitsToPixels(Graphics2D graphics2D, float f, boolean bl) {
        Point2D.Float float_ = new Point2D.Float(f, f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float float_3 = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float float_4 = new Point2D.Float(0.0f, 0.0f);
        graphics2D.getTransform().transform(float_, float_2);
        graphics2D.getTransform().transform(float_3, float_4);
        if (bl) {
            return (float)(((Point2D)float_2).getX() - ((Point2D)float_4).getX());
        }
        return (float)(((Point2D)float_2).getY() - ((Point2D)float_4).getY());
    }

    public static Rectangle2D drawString(Graphics2D graphics2D, String string, double d, double d2, boolean bl, boolean bl2, Color color) {
        return LayerUtilities.drawString(graphics2D, string, d, d2, bl, bl2, color, Color.BLACK);
    }

    public static Rectangle2D drawString(Graphics2D graphics2D, String string, double d, double d2, boolean bl, boolean bl2, Color color, Color color2) {
        AffineTransform affineTransform = graphics2D.getTransform();
        Point2D.Double double_ = new Point2D.Double(d, d2);
        Point2D.Double double_2 = new Point2D.Double();
        affineTransform.transform(double_, double_2);
        try {
            affineTransform.invert();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        graphics2D.transform(affineTransform);
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
        int n = Math.round((float)(((Point2D)double_2).getX() - (bl ? rectangle2D.getWidth() / 2.0 - 1.0 : 0.0)));
        int n2 = Math.round((float)(((Point2D)double_2).getY() + (bl2 ? rectangle2D.getHeight() / 2.0 - 1.5 : 0.0)));
        if (color != null) {
            graphics2D.setColor(color);
            int n3 = (int)(rectangle2D.getMaxY() - rectangle2D.getMinY());
            int n4 = (int)(rectangle2D.getMaxX() - rectangle2D.getMinX());
            graphics2D.fillRect(n, n2 - n3, n4, n3);
        }
        Rectangle2D.Double double_3 = new Rectangle2D.Double(n, (double)n2 - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
        affineTransform.createTransformedShape(double_3);
        graphics2D.setColor(color2);
        graphics2D.drawString(string, n, n2);
        try {
            affineTransform.invert();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        graphics2D.transform(affineTransform);
        return double_3;
    }
}

