/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class LegendLayer
implements Layer {
    List<Color> colors;
    List<String> texts;
    CoordinateSystem cs;
    int pixelsFromRight;

    public LegendLayer(CoordinateSystem coordinateSystem, int n) {
        this.cs = coordinateSystem;
        this.colors = new ArrayList<Color>();
        this.texts = new ArrayList<String>();
        this.pixelsFromRight = n;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        int n = Math.round(this.cs.getMax(Axis.X));
        int n2 = Math.round(this.cs.getMax(Axis.Y));
        for (int i = 0; i < this.colors.size(); ++i) {
            String string = this.texts.get(i);
            Color color = this.colors.get(i);
            int n3 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 14, false));
            int n4 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, this.pixelsFromRight, true));
            LayerUtilities.drawString(graphics2D, string, n - n4, n2 - n3 * (i + 1), false, true, Color.white, color);
        }
    }

    @Override
    public String getName() {
        return "Legend";
    }

    public void addEntry(String string, Color color) {
        this.colors.add(color);
        this.texts.add(string);
    }

    public void removeAllEntries() {
        this.colors.clear();
        this.texts.clear();
    }
}

