/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class MouseCursorLayer
implements Layer,
MouseMotionListener,
MouseListener {
    private boolean drawCursor = false;
    private Point lastPoint = null;
    private Component component = null;
    boolean onlyDrawVertical = false;
    CoordinateSystem cs;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public MouseCursorLayer(CoordinateSystem coordinateSystem) {
        this.cs = coordinateSystem;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.drawCursor) {
            Point2D point2D = LayerUtilities.pixelsToUnits(graphics2D, (int)this.lastPoint.getX(), (int)this.lastPoint.getY());
            graphics2D.setColor(Color.blue);
            if (!this.onlyDrawVertical) {
                graphics2D.drawLine(Math.round(this.cs.getMax(Axis.X)), Math.round((float)point2D.getY()), Math.round(this.cs.getMin(Axis.X)), Math.round((float)point2D.getY()));
                this.pcs.firePropertyChange("cursor", null, this.lastPoint);
            }
            graphics2D.drawLine(Math.round((float)point2D.getX()), (int)Math.floor(this.cs.getMin(Axis.Y)), Math.round((float)point2D.getX()), (int)Math.ceil(this.cs.getMax(Axis.Y)));
        }
    }

    @Override
    public String getName() {
        return "Cursor Layer";
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.lastPoint = mouseEvent.getPoint();
        this.component = mouseEvent.getComponent();
        this.component.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.drawCursor = false;
        this.component = mouseEvent.getComponent();
        this.component.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastPoint = mouseEvent.getPoint();
        this.drawCursor = true;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.lastPoint = mouseEvent.getPoint();
        this.drawCursor = true;
        this.onlyDrawVertical = false;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.drawCursor = false;
        this.component = mouseEvent.getComponent();
        this.component.repaint();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void setPoint(Point point) {
        this.drawCursor = true;
        this.onlyDrawVertical = true;
        this.lastPoint = point;
        if (this.component != null) {
            this.component.repaint();
        }
    }
}

