/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.pitch.PitchDetectionHandler;
import be.tarsos.dsp.pitch.PitchDetectionResult;
import be.tarsos.dsp.pitch.PitchProcessor;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import be.tarsos.dsp.util.PitchConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.sound.sampled.UnsupportedAudioFileException;

public class PitchContourLayer
implements Layer {
    private TreeMap<Double, float[]> features = new TreeMap();
    private final CoordinateSystem cs;
    private final Color color;
    private final int frameSize;
    private final int overlap;
    private final File audioFile;

    public PitchContourLayer(CoordinateSystem coordinateSystem, File file, Color color, int n, int n2) {
        this.cs = coordinateSystem;
        this.color = color;
        this.audioFile = file;
        this.frameSize = n;
        this.overlap = n2;
        this.initialise();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        graphics2D.setColor(this.color);
        int n = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 4, true));
        int n2 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 4, false));
        if (this.features != null) {
            SortedMap<Double, float[]> sortedMap = this.features.subMap((double)this.cs.getMin(Axis.X) / 1000.0, (double)this.cs.getMax(Axis.X) / 1000.0);
            for (Map.Entry entry : sortedMap.entrySet()) {
                double d = (Double)entry.getKey();
                double d2 = ((float[])entry.getValue())[0];
                if (!(d2 > (double)this.cs.getMin(Axis.Y)) || !(d2 < (double)this.cs.getMax(Axis.Y))) continue;
                graphics2D.drawOval((int)(d * 1000.0), (int)d2, n, n2);
            }
        }
    }

    public void initialise() {
        try {
            AudioDispatcher audioDispatcher = AudioDispatcherFactory.fromFile(this.audioFile, this.frameSize, this.overlap);
            final double d = (double)this.frameSize / 44100.0;
            final TreeMap treeMap = new TreeMap();
            audioDispatcher.addAudioProcessor(new PitchProcessor(PitchProcessor.PitchEstimationAlgorithm.FFT_YIN, 44100.0f, this.frameSize, new PitchDetectionHandler(){

                @Override
                public void handlePitch(PitchDetectionResult pitchDetectionResult, AudioEvent audioEvent) {
                    if (pitchDetectionResult.isPitched()) {
                        float[] fArray = new float[]{(float)PitchConverter.hertzToAbsoluteCent(pitchDetectionResult.getPitch())};
                        treeMap.put(audioEvent.getTimeStamp() - d, fArray);
                    }
                }
            }));
            audioDispatcher.addAudioProcessor(new AudioProcessor(){

                @Override
                public void processingFinished() {
                    PitchContourLayer.this.features = treeMap;
                }

                @Override
                public boolean process(AudioEvent audioEvent) {
                    return true;
                }
            });
            new Thread(audioDispatcher).start();
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            unsupportedAudioFileException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "Pitch contour layer";
    }
}

