/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.TooltipLayer;
import be.tarsos.dsp.util.PitchConverter;
import be.tarsos.dsp.wavelet.HaarWaveletTransform;
import be.tarsos.dsp.wavelet.lift.Daubechies4Wavelet;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class Scalogram
implements Layer,
Runnable,
TooltipLayer.TooltipTextGenerator {
    private final String audioFile;
    private TreeMap<Double, ScalogramFrame> features;
    private final CoordinateSystem cs;

    public Scalogram(CoordinateSystem coordinateSystem, String string) {
        this.audioFile = string;
        this.cs = coordinateSystem;
        this.features = null;
        new Thread((Runnable)this, "Extract Scalogram").start();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.features == null) {
            return;
        }
        SortedMap<Double, ScalogramFrame> sortedMap = this.features.subMap((double)this.cs.getMin(Axis.X) / 1000.0, (double)this.cs.getMax(Axis.X) / 1000.0);
        for (Map.Entry entry : sortedMap.entrySet()) {
            double d = (Double)entry.getKey();
            ScalogramFrame scalogramFrame = (ScalogramFrame)entry.getValue();
            for (int i = 0; i < scalogramFrame.dataPerScale.length; ++i) {
                for (int j = 0; j < scalogramFrame.dataPerScale[i].length; ++j) {
                    Color color = Color.black;
                    float f = scalogramFrame.startFrequencyPerLevel[i];
                    float f2 = scalogramFrame.stopFrequencyPerLevel[i] - f;
                    if (!(f + f2 >= this.cs.getMin(Axis.Y)) || !(f <= this.cs.getMax(Axis.Y))) continue;
                    float f3 = Math.abs(scalogramFrame.dataPerScale[i][j] / scalogramFrame.currentMax);
                    double d2 = d + (double)((float)(j + 1) * scalogramFrame.durationsOfBlockPerLevel[i]);
                    double d3 = scalogramFrame.durationsOfBlockPerLevel[i];
                    int n = (int)((double)f3 * 0.99 * 255.0);
                    n = Math.max(0, n);
                    color = new Color(n, n, n);
                    graphics2D.setColor(color);
                    graphics2D.fillRect((int)Math.round(d2 * 1000.0), Math.round(f), (int)Math.round(d3 * 1000.0), (int)Math.ceil(f2));
                }
            }
        }
    }

    @Override
    public String getName() {
        return "Scalogram";
    }

    @Override
    public void run() {
        AudioDispatcher audioDispatcher = AudioDispatcherFactory.fromPipe(this.audioFile, 44100, 131072, 0);
        audioDispatcher.addAudioProcessor(new AudioProcessor(){
            Daubechies4Wavelet wt = new Daubechies4Wavelet();
            TreeMap<Double, ScalogramFrame> calculatigFeatures = new TreeMap();
            ScalogramFrame prevFrame;

            @Override
            public boolean process(AudioEvent audioEvent) {
                float[] fArray = (float[])audioEvent.getFloatBuffer().clone();
                this.wt.forwardTrans(fArray);
                float f = 0.0f;
                if (this.prevFrame != null) {
                    f = this.prevFrame.currentMax * 0.99f;
                }
                ScalogramFrame scalogramFrame = new ScalogramFrame(fArray, f);
                this.calculatigFeatures.put(audioEvent.getTimeStamp(), scalogramFrame);
                this.prevFrame = scalogramFrame;
                return true;
            }

            @Override
            public void processingFinished() {
                Scalogram.this.features = this.calculatigFeatures;
            }
        });
        audioDispatcher.run();
    }

    @Override
    public String generateTooltip(CoordinateSystem coordinateSystem, Point2D point2D) {
        return "Scale info";
    }

    private static class ScalogramFrame {
        float[][] dataPerScale;
        float[] durationsOfBlockPerLevel;
        float[] startFrequencyPerLevel;
        float[] stopFrequencyPerLevel;
        float currentMax;

        public ScalogramFrame(float[] fArray, float f) {
            this.currentMax = f;
            int n = HaarWaveletTransform.log2(fArray.length);
            this.dataPerScale = new float[n][];
            this.durationsOfBlockPerLevel = new float[n];
            this.startFrequencyPerLevel = new float[n];
            this.stopFrequencyPerLevel = new float[n];
            for (int i = 0; i < n; ++i) {
                int n2 = HaarWaveletTransform.pow2(i);
                this.dataPerScale[i] = new float[n2];
                this.durationsOfBlockPerLevel[i] = 131072.0f / (float)n2 / 44100.0f;
                this.stopFrequencyPerLevel[i] = (float)PitchConverter.hertzToAbsoluteCent(44100.0f / (float)HaarWaveletTransform.pow2(n - i));
                if (i > 0) {
                    this.startFrequencyPerLevel[i] = this.stopFrequencyPerLevel[i - 1];
                }
                this.mra(fArray, i, this.dataPerScale);
            }
        }

        private void mra(float[] fArray, int n, float[][] fArray2) {
            int n2 = fArray.length / HaarWaveletTransform.pow2(fArray2.length - n);
            int n3 = fArray.length / HaarWaveletTransform.pow2(fArray2.length - n - 1);
            int n4 = 0;
            for (int i = n2; i < n3; ++i) {
                fArray2[n][n4] = -1.0f * fArray[i];
                ++n4;
            }
            this.normalize(fArray2[n]);
        }

        private void normalize(float[] fArray) {
            int n;
            for (n = 0; n < fArray.length; ++n) {
                this.currentMax = Math.max(Math.abs(fArray[n]), this.currentMax);
            }
            for (n = 0; n < fArray.length; ++n) {
            }
        }
    }
}

