/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.LinkedPanel;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class SelectionLayer
extends MouseAdapter
implements Layer {
    private final CoordinateSystem cs;
    private final Color color;

    public SelectionLayer(CoordinateSystem coordinateSystem) {
        this(coordinateSystem, Color.ORANGE);
    }

    public SelectionLayer(CoordinateSystem coordinateSystem, Color color) {
        this.cs = coordinateSystem;
        this.color = color;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        double d = this.cs.getStartX();
        double d2 = this.cs.getStartY();
        double d3 = this.cs.getEndX();
        double d4 = this.cs.getEndY();
        if (d != Double.MAX_VALUE) {
            double d5;
            if (d > d3) {
                d5 = d;
                d = d3;
                d3 = d5;
            }
            if (d2 > d4) {
                d5 = d2;
                d2 = d4;
                d4 = d5;
            }
            int n = (int)Math.round(d);
            int n2 = (int)Math.round(d2);
            int n3 = (int)Math.round(d3) - n;
            int n4 = (int)Math.round(d4) - n2;
            graphics2D.setColor(this.color);
            graphics2D.drawRect(n, n2, n3, n4);
        }
    }

    @Override
    public String getName() {
        return "Selection Layer";
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            LinkedPanel linkedPanel = (LinkedPanel)mouseEvent.getComponent();
            Graphics2D graphics2D = (Graphics2D)linkedPanel.getGraphics();
            graphics2D.setTransform(linkedPanel.getTransform());
            Point2D point2D = LayerUtilities.pixelsToUnits(graphics2D, mouseEvent.getX(), mouseEvent.getY());
            if (!linkedPanel.getCoordinateSystem().hasStartPoint()) {
                linkedPanel.getCoordinateSystem().setStartPoint(point2D.getX(), point2D.getY());
            } else {
                linkedPanel.getCoordinateSystem().setEndPoint(point2D.getX(), point2D.getY());
            }
            linkedPanel.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            LinkedPanel linkedPanel = (LinkedPanel)mouseEvent.getComponent();
            linkedPanel.getViewPort().zoomToSelection();
            linkedPanel.invalidate();
        }
    }
}

