/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import be.tarsos.dsp.util.PitchConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class SpectrumLayer
implements Layer {
    private float[] spectrum;
    private List<Integer> peaksInBins;
    private float multiplier = 10.0f;
    private int sampleRate;
    private int fftSize;
    private CoordinateSystem cs;
    private final Color color;

    public SpectrumLayer(CoordinateSystem coordinateSystem, int n, int n2, Color color) {
        this.cs = coordinateSystem;
        this.sampleRate = n2;
        this.fftSize = n;
        this.color = color;
        this.peaksInBins = new ArrayList<Integer>();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.spectrum != null) {
            int n;
            int n2;
            int n3;
            graphics2D.setColor(this.color);
            int n4 = 0;
            int n5 = 0;
            for (n3 = 1; n3 < this.spectrum.length; ++n3) {
                float f = (float)(n3 * this.sampleRate) / (float)this.fftSize;
                n2 = (int)Math.round(PitchConverter.hertzToAbsoluteCent(f));
                n = Math.round(this.spectrum[n3] * this.multiplier);
                if (!(this.cs.getMin(Axis.X) < (float)n2) || !((float)n2 < this.cs.getMax(Axis.X))) continue;
                graphics2D.drawLine(n4, n5, n2, n);
                n4 = n2;
                n5 = n;
            }
            n3 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 7, true));
            int n6 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 7, false));
            graphics2D.setColor(Color.blue);
            for (n2 = 0; n2 < this.peaksInBins.size(); ++n2) {
                n = this.peaksInBins.get(n2);
                float f = (float)(n * this.sampleRate) / (float)this.fftSize;
                int n7 = (int)Math.round(PitchConverter.hertzToAbsoluteCent(f) - (double)((float)n3 / 2.0f));
                if (!(this.cs.getMin(Axis.X) < (float)n7) || !((float)n7 < this.cs.getMax(Axis.X))) continue;
                int n8 = Math.round(this.spectrum[n] * this.multiplier - (float)n6 / 2.0f);
                graphics2D.drawOval(Math.round(n7), n8, n3, n6);
            }
        }
    }

    @Override
    public String getName() {
        return "Spectrum";
    }

    public void setSpectrum(float[] fArray) {
        this.spectrum = fArray;
    }

    public void setPeak(int n) {
        this.peaksInBins.add(n);
    }

    public void clearPeaks() {
        this.peaksInBins.clear();
    }

    public void setSampleRate(int n) {
        this.sampleRate = n;
    }

    public void setFFTSize(int n) {
        this.fftSize = n;
    }
}

