/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.AxisUnit;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;

public class TimeAxisLayer
implements Layer {
    private int[] intervals = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000};
    private int intervalIndex;
    CoordinateSystem cs;

    public TimeAxisLayer(CoordinateSystem coordinateSystem) {
        this.cs = coordinateSystem;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.cs.getUnitsForAxis(Axis.X) == AxisUnit.TIME) {
            int n;
            graphics2D.setColor(Color.black);
            int n2 = Math.round(this.cs.getMin(Axis.Y));
            int n3 = Math.round(this.cs.getMax(Axis.X));
            int n4 = 1000;
            this.intervalIndex = 0;
            int n5 = n4 * this.intervals[this.intervalIndex];
            int n6 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 9, false));
            int n7 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 12, false));
            int n8 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 4, false));
            int n9 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 9, false));
            int n10 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 2, false));
            int n11 = (int)this.cs.getMin(Axis.X);
            int n12 = (int)this.cs.getMax(Axis.X);
            int n13 = n12 - n11;
            if (n13 >= 240000) {
                for (n = n11; n < n12; ++n) {
                    if (n % (n5 * 60) != 0) continue;
                    graphics2D.drawLine(n, n2, n, n2 + n6);
                    String string = String.valueOf(n / 1000);
                    LayerUtilities.drawString(graphics2D, string, n, n2 + n7, true, false, null);
                }
            } else if (n13 >= 120000 && n13 < 240000) {
                for (n = n11; n < n12; ++n) {
                    if (n % (n5 * 10) != 0) continue;
                    graphics2D.drawLine(n, n2, n, n2 + n6);
                    String string = String.valueOf(n / 1000);
                    LayerUtilities.drawString(graphics2D, string, n, n2 + n7, true, false, null);
                }
            } else if (n13 >= 30000 && n13 < 120000) {
                for (n = n11; n < n12; ++n) {
                    if (n % (n5 * 5) == 0) {
                        graphics2D.drawLine(n, n2, n, n2 + n6);
                        String string = String.valueOf(n / 1000);
                        LayerUtilities.drawString(graphics2D, string, n, n2 + n7, true, false, null);
                        continue;
                    }
                    if (n % n5 != 0) continue;
                    graphics2D.drawLine(n, n2, n, n2 + n8);
                }
            } else if (n13 > 10000 && n13 < 30000) {
                for (n = n11; n < n12; ++n) {
                    String string;
                    if (n % (n5 * 5) == 0) {
                        graphics2D.drawLine(n, n2, n, n2 + n6);
                        string = String.valueOf(n / 1000);
                        LayerUtilities.drawString(graphics2D, string, n, n2 + n7, true, false, null);
                        continue;
                    }
                    if (n % n5 != 0) continue;
                    graphics2D.drawLine(n, n2, n, n2 + n8);
                    string = String.valueOf(n / 1000);
                    LayerUtilities.drawString(graphics2D, string, n, n2 + n9, true, false, null);
                }
            } else {
                for (n = n11; n < n12; ++n) {
                    String string;
                    if (n % (n5 * 5) == 0) {
                        graphics2D.drawLine(n, n2, n, n2 + n6);
                        string = String.valueOf(n / 1000);
                        LayerUtilities.drawString(graphics2D, string, n, n2 + n7, true, false, null);
                        continue;
                    }
                    if (n % n5 == 0) {
                        graphics2D.drawLine(n, n2, n, n2 + n8);
                        string = String.valueOf(n / 1000);
                        LayerUtilities.drawString(graphics2D, string, n, n2 + n9, true, false, null);
                        continue;
                    }
                    if (n % 100 != 0) continue;
                    graphics2D.drawLine(n, n2, n, n2 + n10);
                }
            }
            n = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 26, true));
            n7 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 14, false));
            LayerUtilities.drawString(graphics2D, "Time (s)", n3 - n, n2 + n7, true, true, Color.white);
        }
    }

    @Override
    public String getName() {
        return "Time axis";
    }
}

