/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public class TooltipLayer
implements Layer,
MouseMotionListener,
MouseListener {
    private boolean enableTooltip = false;
    private int millisecondsBeforAppearance = 1000;
    private long mouseStoppedAtMilliseconds = System.currentTimeMillis();
    private Point lastPoint = null;
    private Point lastDrawnPoint = null;
    private Component component = null;
    private final CoordinateSystem cs;
    private final TooltipTextGenerator tooltipTextGenerator;
    private static final TooltipTextGenerator defaultTooltipGenerator = new TooltipTextGenerator(){

        @Override
        public String generateTooltip(CoordinateSystem coordinateSystem, Point2D point2D) {
            return String.format("[%.03f%s , %.02f%s]", point2D.getX() / 1000.0, coordinateSystem.getUnitsForAxis(Axis.X).getUnit(), point2D.getY(), coordinateSystem.getUnitsForAxis(Axis.Y).getUnit());
        }
    };

    public TooltipLayer(CoordinateSystem coordinateSystem) {
        this(coordinateSystem, defaultTooltipGenerator);
    }

    public TooltipLayer(CoordinateSystem coordinateSystem, TooltipTextGenerator tooltipTextGenerator) {
        this.cs = coordinateSystem;
        this.tooltipTextGenerator = tooltipTextGenerator;
        Thread thread = new Thread(new Runnable(){

            private void sleep() {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            @Override
            public void run() {
                while (true) {
                    this.sleep();
                    long l = System.currentTimeMillis() - TooltipLayer.this.mouseStoppedAtMilliseconds;
                    if (TooltipLayer.this.component == null || l <= (long)TooltipLayer.this.millisecondsBeforAppearance || TooltipLayer.this.lastDrawnPoint == TooltipLayer.this.lastPoint) continue;
                    TooltipLayer.this.component.repaint();
                }
            }
        }, "Tooltip Repaint Check");
        thread.start();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        long l = System.currentTimeMillis() - this.mouseStoppedAtMilliseconds;
        if (this.enableTooltip && l > (long)this.millisecondsBeforAppearance) {
            Point2D point2D = LayerUtilities.pixelsToUnits(graphics2D, (int)this.lastPoint.getX(), (int)this.lastPoint.getY());
            int n = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 10, false));
            int n2 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 10, true));
            String string = this.tooltipTextGenerator.generateTooltip(this.cs, point2D);
            LayerUtilities.drawString(graphics2D, string, point2D.getX() + (double)n2, point2D.getY() + (double)n, false, true, Color.white, Color.black);
            this.lastDrawnPoint = this.lastPoint;
        }
    }

    @Override
    public String getName() {
        return "Tooltip Layer";
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.enableTooltip = false;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.lastPoint = mouseEvent.getPoint();
        this.component = mouseEvent.getComponent();
        this.mouseStoppedAtMilliseconds = System.currentTimeMillis();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.enableTooltip = false;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.enableTooltip = true;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.lastPoint = mouseEvent.getPoint();
        this.component = mouseEvent.getComponent();
        this.enableTooltip = true;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.enableTooltip = false;
    }

    public static interface TooltipTextGenerator {
        public String generateTooltip(CoordinateSystem var1, Point2D var2);
    }
}

