/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;

public class VerticalFrequencyAxisLayer
implements Layer {
    CoordinateSystem cs;

    public VerticalFrequencyAxisLayer(CoordinateSystem coordinateSystem) {
        this.cs = coordinateSystem;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        graphics2D.setColor(Color.black);
        int n = Math.round(this.cs.getMin(Axis.X));
        int n2 = Math.round(this.cs.getMax(Axis.Y));
        int n3 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 8, true));
        int n4 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 4, true));
        int n5 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 12, true));
        int n6 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 12, false));
        int n7 = (int)this.cs.getMin(Axis.Y);
        while ((float)n7 < this.cs.getMax(Axis.Y)) {
            if (n7 % 1200 == 0) {
                graphics2D.drawLine(n, n7, n + n3, n7);
                String string = String.valueOf(n7);
                LayerUtilities.drawString(graphics2D, string, n + n5, n7, false, true, null);
            } else if (n7 % 100 == 0) {
                graphics2D.drawLine(n, n7, n + n4, n7);
            }
            ++n7;
        }
        LayerUtilities.drawString(graphics2D, "Frequency (cents)", n + n5, n2 - n6, false, true, Color.white);
    }

    @Override
    public String getName() {
        return "Frequency Axis";
    }
}

