/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaveFormLayer
implements Layer {
    private final Color waveFormColor = Color.black;
    private final CoordinateSystem cs;
    private final File audioFile;
    private float[] samples;
    private float sampleRate;

    public WaveFormLayer(CoordinateSystem coordinateSystem, File file) {
        this.cs = coordinateSystem;
        this.audioFile = file;
        this.initialise();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        graphics2D.setColor(this.waveFormColor);
        this.drawWaveForm(graphics2D);
    }

    private void drawWaveForm(Graphics2D graphics2D) {
        int n = (int)this.cs.getMin(Axis.X);
        int n2 = (int)this.cs.getMax(Axis.X);
        graphics2D.setColor(Color.GRAY);
        graphics2D.drawLine(n, 0, n2, 0);
        graphics2D.setColor(Color.BLACK);
        if (this.samples != null && this.samples.length > 0) {
            int n3 = (int)this.cs.getDelta(Axis.Y);
            float f = (float)this.samples.length / this.sampleRate * 1000.0f;
            int n4 = this.samples.length;
            float f2 = (float)n4 / f;
            int n5 = n3 / 2;
            int n6 = 1;
            int n7 = Math.max(0, n);
            while ((float)n7 < Math.min((float)n2, f)) {
                int n8 = (int)((float)n7 * f2);
                if (n8 < this.samples.length) {
                    graphics2D.drawLine(n7, 0, n7, (int)(this.samples[n8] * (float)n5));
                }
                n7 += n6;
            }
        }
    }

    public void initialise() {
        try {
            AudioDispatcher audioDispatcher = AudioDispatcherFactory.fromFile(this.audioFile, 52920000, 0);
            audioDispatcher.setZeroPadLastBuffer(false);
            this.sampleRate = audioDispatcher.getFormat().getSampleRate();
            audioDispatcher.addAudioProcessor(new AudioProcessor(){

                @Override
                public void processingFinished() {
                }

                @Override
                public boolean process(AudioEvent audioEvent) {
                    float[] fArray = audioEvent.getFloatBuffer();
                    WaveFormLayer.access$002(WaveFormLayer.this, (float[])fArray.clone());
                    return true;
                }
            });
            new Thread(audioDispatcher).start();
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            unsupportedAudioFileException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "Waveform layer";
    }

    static /* synthetic */ float[] access$002(WaveFormLayer waveFormLayer, float[] fArray) {
        waveFormLayer.samples = fArray;
        return fArray;
    }
}

