/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers.pch;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.LinkedPanel;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class ScaleLayer
extends MouseAdapter
implements Layer,
MouseMotionListener,
KeyListener {
    private double movingElement = -1.0;
    private double[] scale;
    private final CoordinateSystem cs;
    private final boolean enableEditor;

    public ScaleLayer(CoordinateSystem coordinateSystem, boolean bl) {
        this.cs = coordinateSystem;
        double[] dArray = new double[]{0.0, 100.0, 200.0, 400.0, 1000.0, 1100.0};
        this.scale = dArray;
        this.enableEditor = bl;
    }

    @Override
    public String getName() {
        return "Scale Editor Layer";
    }

    public void setScale(double[] dArray) {
        this.scale = dArray;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        graphics2D.setColor(Color.black);
        int n = Math.round(this.cs.getMin(Axis.Y));
        int n2 = Math.round(this.cs.getMax(Axis.Y));
        int n3 = Math.round(this.cs.getMax(Axis.X));
        int n4 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 20, false));
        int n5 = (int)this.cs.getMin(Axis.X);
        while ((float)n5 < this.cs.getMax(Axis.X)) {
            int n6 = (int)this.cs.getRealXValue(n5);
            for (double d : this.scale) {
                if (n6 != (int)d) continue;
                if (d == this.movingElement) {
                    graphics2D.setColor(Color.RED);
                } else if (this.enableEditor) {
                    graphics2D.setColor(Color.GRAY);
                } else {
                    graphics2D.setColor(Color.LIGHT_GRAY);
                }
                graphics2D.drawLine(n5, n + (int)(1.5 * (double)n4), n5, n2 - (int)(1.5 * (double)n4));
                String string = String.valueOf(n6);
                if (this.enableEditor) {
                    LayerUtilities.drawString(graphics2D, string, n5, n + n4, true, false, null);
                    continue;
                }
                LayerUtilities.drawString(graphics2D, string, n5, n2 - n4, true, false, null);
            }
            ++n5;
        }
        n5 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 60, true));
        n4 = Math.round(LayerUtilities.pixelsToUnits(graphics2D, 10, false));
        LayerUtilities.drawString(graphics2D, "Frequency (cents)", n3 - n5, n2 - n4, true, true, Color.white);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.enableEditor) {
            return;
        }
        if (this.movingElement != -1.0) {
            Arrays.sort(this.scale);
        }
        this.movingElement = -1.0;
        mouseEvent.getComponent().repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.enableEditor) {
            return;
        }
        mouseEvent.getComponent().requestFocus();
        if (mouseEvent.isAltDown() || mouseEvent.isAltGraphDown()) {
            mouseEvent.getComponent().requestFocus();
            if (this.movingElement != -1.0) {
                int n = -1;
                for (int i = 0; i < this.scale.length; ++i) {
                    if (this.scale[i] != this.movingElement) continue;
                    n = i;
                }
                if (n == -1) {
                    this.movingElement = -1.0;
                } else {
                    this.scale[n] = this.getCents(mouseEvent);
                    this.movingElement = this.scale[n];
                }
                mouseEvent.getComponent().repaint();
            } else {
                double[] dArray = new double[this.scale.length + 1];
                for (int i = 0; i < this.scale.length; ++i) {
                    dArray[i] = this.scale[i];
                }
                dArray[dArray.length - 1] = this.getCents(mouseEvent);
                this.movingElement = dArray[dArray.length - 1];
                Arrays.sort(dArray);
                this.scale = dArray;
                mouseEvent.getComponent().repaint();
            }
        } else if (mouseEvent.isControlDown() && this.scale.length > 0) {
            int n;
            if (this.movingElement == -1.0) {
                n = this.closestIndex(this.getCents(mouseEvent));
                this.movingElement = this.scale[n];
            }
            for (n = 0; n < this.scale.length; ++n) {
                if (this.scale[n] != this.movingElement) continue;
                this.scale[n] = this.getCents(mouseEvent);
                this.movingElement = this.scale[n];
            }
            mouseEvent.getComponent().repaint();
        }
    }

    private double getCents(MouseEvent mouseEvent) {
        LinkedPanel linkedPanel = (LinkedPanel)mouseEvent.getComponent();
        Graphics2D graphics2D = (Graphics2D)linkedPanel.getGraphics();
        graphics2D.setTransform(linkedPanel.getTransform());
        Point2D point2D = LayerUtilities.pixelsToUnits(graphics2D, mouseEvent.getX(), mouseEvent.getY());
        return this.cs.getRealXValue((float)point2D.getX());
    }

    private int closestIndex(double d) {
        double d2 = Double.MAX_VALUE;
        int n = -1;
        for (int i = 0; i < this.scale.length; ++i) {
            double d3;
            double d4 = Math.abs(d - this.scale[i]);
            if (!(Math.min(d4, d3 = Math.abs(d - (this.scale[i] + 1200.0))) < d2)) continue;
            d2 = Math.min(d4, d3);
            n = i;
        }
        return n;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        boolean bl;
        if (!this.enableEditor) {
            return;
        }
        boolean bl2 = this.movingElement != -1.0;
        boolean bl3 = bl = keyEvent.getKeyChar() == 'd' || keyEvent.getKeyCode() == 127 || keyEvent.getKeyChar() == '\u007f';
        if (bl2 && bl) {
            double[] dArray = new double[this.scale.length - 1];
            int n = 0;
            for (int i = 0; i < this.scale.length; ++i) {
                if (this.scale[i] == this.movingElement) continue;
                dArray[n] = this.scale[i];
                ++n;
            }
            Arrays.sort(dArray);
            this.scale = dArray;
            this.movingElement = -1.0;
            keyEvent.getComponent().repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

