/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public class AudioResourceUtils {
    private AudioResourceUtils() {
    }

    public static String sanitizeResource(String string) {
        if (string.toLowerCase().endsWith("pls")) {
            string = AudioResourceUtils.parsePLS(string);
        } else if (string.toLowerCase().endsWith("m3u")) {
            string = AudioResourceUtils.parseM3U(string);
        } else if (string.toLowerCase().endsWith("asx")) {
            string = AudioResourceUtils.parseASX(string);
        } else if (string.toLowerCase().endsWith("xspf")) {
            string = AudioResourceUtils.parseXSPF(string);
        }
        return string;
    }

    private static String parseXSPF(String string) {
        String string2 = "";
        try {
            String string3 = AudioResourceUtils.readTextFromUrl(new URL(string));
            for (String string4 : string3.split("\n")) {
                if (!string4.toLowerCase().contains("href")) continue;
                String string5 = "(?i)<location>(.*)</location>.*";
                string2 = string4.replaceAll(string5, "$1");
                break;
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return string2;
    }

    private static String parseASX(String string) {
        String string2 = "";
        try {
            String string3 = AudioResourceUtils.readTextFromUrl(new URL(string));
            for (String string4 : string3.split("\n")) {
                if (!string4.toLowerCase().contains("href")) continue;
                String string5 = "(?i).*href=\"(.*)\".*";
                string2 = string4.replaceAll(string5, "$1");
                break;
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return string2;
    }

    public static String parsePLS(String string) {
        String string2 = "";
        try {
            String string3 = AudioResourceUtils.readTextFromUrl(new URL(string));
            for (String string4 : string3.split("\n")) {
                if (!string4.startsWith("File1=")) continue;
                string2 = string4.replace("File1=", "").trim();
                break;
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return string2;
    }

    public static String parseM3U(String string) {
        String string2 = "";
        try {
            String string3 = AudioResourceUtils.readTextFromUrl(new URL(string));
            for (String string4 : string3.split("\n")) {
                if (string4.trim().isEmpty() || string4.trim().startsWith("#")) continue;
                string2 = string4.trim();
                break;
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return string2;
    }

    public static String readTextFromUrl(URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string).append("\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }
}

