/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.util;

public class Complex {
    private double x;
    private double y;

    public Complex(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public double real() {
        return this.x;
    }

    public double imag() {
        return this.y;
    }

    public double mod() {
        if (this.x != 0.0 || this.y != 0.0) {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }
        return 0.0;
    }

    public double arg() {
        return Math.atan2(this.y, this.x);
    }

    public Complex conj() {
        return new Complex(this.x, -this.y);
    }

    public Complex plus(Complex complex) {
        return new Complex(this.x + complex.real(), this.y + complex.imag());
    }

    public Complex minus(Complex complex) {
        return new Complex(this.x - complex.real(), this.y - complex.imag());
    }

    public Complex times(Complex complex) {
        return new Complex(this.x * complex.real() - this.y * complex.imag(), this.x * complex.imag() + this.y * complex.real());
    }

    public Complex div(Complex complex) {
        double d = Math.pow(complex.mod(), 2.0);
        return new Complex((this.x * complex.real() + this.y * complex.imag()) / d, (this.y * complex.real() - this.x * complex.imag()) / d);
    }

    public Complex exp() {
        return new Complex(Math.exp(this.x) * Math.cos(this.y), Math.exp(this.x) * Math.sin(this.y));
    }

    public Complex log() {
        return new Complex(Math.log(this.mod()), this.arg());
    }

    public Complex sqrt() {
        double d = Math.sqrt(this.mod());
        double d2 = this.arg() / 2.0;
        return new Complex(d * Math.cos(d2), d * Math.sin(d2));
    }

    private double cosh(double d) {
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }

    private double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    public Complex sin() {
        return new Complex(this.cosh(this.y) * Math.sin(this.x), this.sinh(this.y) * Math.cos(this.x));
    }

    public Complex cos() {
        return new Complex(this.cosh(this.y) * Math.cos(this.x), -this.sinh(this.y) * Math.sin(this.x));
    }

    public Complex sinh() {
        return new Complex(this.sinh(this.x) * Math.cos(this.y), this.cosh(this.x) * Math.sin(this.y));
    }

    public Complex cosh() {
        return new Complex(this.cosh(this.x) * Math.cos(this.y), this.sinh(this.x) * Math.sin(this.y));
    }

    public Complex tan() {
        return this.sin().div(this.cos());
    }

    public Complex chs() {
        return new Complex(-this.x, -this.y);
    }

    public String toString() {
        if (this.x != 0.0 && this.y > 0.0) {
            return this.x + " + " + this.y + "i";
        }
        if (this.x != 0.0 && this.y < 0.0) {
            return this.x + " - " + -this.y + "i";
        }
        if (this.y == 0.0) {
            return String.valueOf(this.x);
        }
        if (this.x == 0.0) {
            return this.y + "i";
        }
        return this.x + " + i*" + this.y;
    }
}

