/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;

public class FFMPEGDownloader {
    private static String url = "https://0110.be/releases/TarsosDSP/TarsosDSP-static-ffmpeg/";
    private final String ffmpegBinary;
    private static final Logger LOG = Logger.getLogger(FFMPEGDownloader.class.getName());

    public FFMPEGDownloader() {
        String string = this.operatingSystemName() + "_" + this.processorArchitecture() + "_ffmpeg" + this.suffix();
        url = url + string;
        String string2 = System.getProperty("java.io.tmpdir");
        String string3 = new File(string2, string).getAbsolutePath();
        if (new File(string3).exists()) {
            LOG.info("Found an already download ffmpeg static binary: " + string3);
            this.ffmpegBinary = string3;
        } else {
            LOG.info("Started downloading an ffmpeg static binary from  " + url);
            this.downloadExecutable(string3);
            if (new File(string3).exists()) {
                LOG.info("Downloaded an ffmpeg static binary. Stored at: " + string3);
                new File(string3).setExecutable(true);
                this.ffmpegBinary = string3;
            } else {
                LOG.warning("Unable to find or download an ffmpeg static binary.  " + string);
                this.ffmpegBinary = null;
            }
        }
    }

    public String ffmpegBinary() {
        if (this.ffmpegBinary != null) {
            return this.ffmpegBinary.replace(this.suffix(), "");
        }
        return null;
    }

    private void downloadExecutable(String string) {
        try {
            URL uRL = new URL(url);
            ReadableByteChannel readableByteChannel = Channels.newChannel(uRL.openStream());
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            fileOutputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String operatingSystemName() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = string.indexOf("indows") > 0 ? "windows" : (string.indexOf("nux") >= 0 ? "linux" : (string.indexOf("mac") >= 0 ? "mac_os_x" : null));
        return string2;
    }

    private String processorArchitecture() {
        boolean bl = false;
        if (System.getProperty("os.name").contains("Windows")) {
            bl = System.getenv("ProgramFiles(x86)") != null;
        } else {
            boolean bl2 = bl = System.getProperty("os.arch").indexOf("64") != -1;
        }
        if (bl) {
            return "64_bits";
        }
        return "32_bits";
    }

    private String suffix() {
        String string = "";
        if (System.getProperty("os.name").contains("Windows")) {
            string = ".exe";
        }
        return string;
    }

    public static void main(String ... stringArray) {
        new FFMPEGDownloader();
    }
}

