/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.util;

import be.tarsos.dsp.util.BiQuadFilter;
import java.util.Arrays;

public class PeakPicker {
    private double threshold;
    private int win_post;
    private int win_pre;
    private BiQuadFilter biquad = new BiQuadFilter(0.16, 0.32, 0.16, -0.5949, 0.2348);
    private float[] onset_keep;
    private float[] onset_proc;
    private float[] onset_peek;
    private float[] scratch;
    private float lastPeekValue;

    public PeakPicker(double d) {
        this.threshold = d;
        this.win_post = 5;
        this.win_pre = 1;
        this.onset_keep = new float[this.win_post + this.win_pre + 1];
        this.onset_proc = new float[this.win_post + this.win_pre + 1];
        this.scratch = new float[this.win_post + this.win_pre + 1];
        this.onset_peek = new float[3];
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    public boolean pickPeak(float f) {
        int n;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n2 = this.win_post + this.win_pre + 1;
        for (int i = 0; i < n2 - 1; ++i) {
            this.onset_keep[i] = this.onset_keep[i + 1];
            this.onset_proc[i] = this.onset_keep[i];
        }
        this.onset_keep[n2 - 1] = f;
        this.onset_proc[n2 - 1] = f;
        this.biquad.doFiltering(this.onset_proc, this.scratch);
        float f4 = 0.0f;
        for (n = 0; n < n2; ++n) {
            this.scratch[n] = this.onset_proc[n];
            f4 += this.scratch[n];
        }
        Arrays.sort(this.scratch);
        f3 = this.scratch[this.scratch.length / 2];
        f2 = f4 / Float.valueOf(n2).floatValue();
        for (n = 0; n < 2; ++n) {
            this.onset_peek[n] = this.onset_peek[n + 1];
        }
        this.onset_peek[2] = (float)((double)(this.onset_proc[this.win_post] - f3) - (double)f2 * this.threshold);
        n = this.isPeak(1) ? 1 : 0;
        this.lastPeekValue = f;
        return n != 0;
    }

    public float getLastPeekValue() {
        return this.lastPeekValue;
    }

    private boolean isPeak(int n) {
        return this.onset_peek[n] > this.onset_peek[n - 1] && this.onset_peek[n] > this.onset_peek[n + 1] && (double)this.onset_peek[n] > 0.0;
    }
}

