/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.util;

public final class PitchConverter {
    private static final double REF_FREQ = 8.17579892;
    private static final double LOG_TWO = Math.log(2.0);

    private PitchConverter() {
    }

    public static int hertzToMidiKey(Double d) {
        int n = (int)Math.round(PitchConverter.hertzToMidiCent(d));
        if (n < 0 || n > 127) {
            // empty if block
        }
        return n;
    }

    public static double midiKeyToHertz(int n) {
        if (n < 0 || n > 127) {
            throw new IllegalArgumentException("MIDI keys are values from 0 to 127, inclusive " + n + " is invalid.");
        }
        return PitchConverter.midiCentToHertz(n);
    }

    public static double hertzToRelativeCent(double d) {
        double d2 = PitchConverter.hertzToAbsoluteCent(d);
        if (d2 < 0.0) {
            d2 = Math.abs(1200.0 + d2);
        }
        return d2 % 1200.0;
    }

    public static double hertzToAbsoluteCent(double d) {
        double d2 = 0.0;
        if (!(d > 0.0)) {
            throw new IllegalArgumentException("Pitch in Hz schould be greater than zero, is " + d);
        }
        d2 = 1200.0 * Math.log(d / 8.17579892) / LOG_TWO;
        return d2;
    }

    public static double absoluteCentToHertz(double d) {
        return 8.17579892 * Math.pow(2.0, d / 1200.0);
    }

    public static double hertzToMidiCent(double d) {
        double d2 = 0.0;
        if (d != 0.0) {
            d2 = 12.0 * Math.log(d / 440.0) / LOG_TWO + 69.0;
        }
        return d2;
    }

    public static double midiCentToHertz(double d) {
        return 440.0 * Math.pow(2.0, (d - 69.0) / 12.0);
    }

    public static double centToRatio(double d) {
        double d2 = Math.pow(10.0, Math.log10(2.0) * d / 1200.0);
        return d2;
    }

    public static double ratioToCent(double d) {
        double d2 = 1200.0 / Math.log10(2.0) * Math.log10(d);
        return d2;
    }
}

