/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.util.fft;

import be.tarsos.dsp.util.fft.FloatFFT;
import be.tarsos.dsp.util.fft.WindowFunction;

public class FFT {
    private final FloatFFT fft;
    private final WindowFunction windowFunction;
    private final int fftSize;
    private final float[] window;

    public FFT(int n) {
        this(n, null);
    }

    public FFT(int n, WindowFunction windowFunction) {
        this.fft = new FloatFFT(n);
        this.fftSize = n;
        this.windowFunction = windowFunction;
        this.window = (float[])(windowFunction == null ? null : windowFunction.generateCurve(n));
    }

    public void forwardTransform(float[] fArray) {
        if (this.windowFunction != null) {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = fArray[i] * this.window[i];
            }
        }
        this.fft.realForward(fArray);
    }

    public void complexForwardTransform(float[] fArray) {
        if (this.windowFunction != null) {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = fArray[i] * this.window[i];
            }
        }
        this.fft.complexForward(fArray);
    }

    public void backwardsTransform(float[] fArray) {
        this.fft.realInverse(fArray, true);
    }

    public double binToHz(int n, float f) {
        return (double)((float)n * f) / (double)this.fftSize;
    }

    public int size() {
        return this.fftSize;
    }

    public float modulus(float[] fArray, int n) {
        int n2 = 2 * n;
        int n3 = 2 * n + 1;
        float f = fArray[n2] * fArray[n2] + fArray[n3] * fArray[n3];
        return (float)Math.sqrt(f);
    }

    public void modulus(float[] fArray, float[] fArray2) {
        assert (fArray.length / 2 == fArray2.length);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray2[i] = this.modulus(fArray, i);
        }
    }

    public void powerPhaseFFT(float[] fArray, float[] fArray2, float[] fArray3) {
        assert (fArray.length / 2 == fArray2.length);
        assert (fArray.length / 2 == fArray3.length);
        if (this.windowFunction != null) {
            this.windowFunction.apply(fArray);
        }
        this.fft.realForward(fArray);
        this.powerAndPhaseFromFFT(fArray, fArray2, fArray3);
    }

    public void powerAndPhaseFromFFT(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray3[0] = (float)Math.PI;
        fArray2[0] = -fArray[0];
        for (int i = 1; i < fArray2.length; ++i) {
            int n = 2 * i;
            int n2 = 2 * i + 1;
            fArray2[i] = (float)Math.sqrt(fArray[n] * fArray[n] + fArray[n2] * fArray[n2]);
            fArray3[i] = (float)Math.atan2(fArray[n2], fArray[n]);
        }
    }

    public void powerPhaseFFTBeatRootOnset(float[] fArray, float[] fArray2, float[] fArray3) {
        this.powerPhaseFFT(fArray, fArray2, fArray3);
        fArray2[0] = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1]);
    }

    public void multiply(float[] fArray, float[] fArray2) {
        assert (fArray.length == fArray2.length);
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Both arrays with imaginary numbers shouldb e of equal length");
        }
        for (int i = 1; i < fArray.length - 1; i += 2) {
            int n = i;
            int n2 = i + 1;
            float f = fArray[n] * fArray2[n] + -1.0f * fArray[n2] * fArray2[n2];
            float f2 = fArray[n] * fArray2[n2] + fArray[n2] * fArray2[n];
            fArray[n] = f;
            fArray[n2] = f2;
        }
    }
}

