/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.wavelet.HaarWaveletTransform;
import java.util.Arrays;

public class HaarWaveletCoder
implements AudioProcessor {
    private final HaarWaveletTransform transform = new HaarWaveletTransform();
    private int compression;

    public HaarWaveletCoder() {
        this(16);
    }

    public HaarWaveletCoder(int n) {
        this.compression = n;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        float[] fArray2 = new float[fArray.length];
        this.transform.transform(audioEvent.getFloatBuffer());
        for (int i = 0; i < fArray2.length; ++i) {
            fArray2[i] = Math.abs(fArray[i]);
        }
        Arrays.sort(fArray2);
        double d = fArray2[this.compression];
        for (int i = 0; i < fArray.length; ++i) {
            if (!((double)Math.abs(fArray[i]) <= d)) continue;
            fArray[i] = 0.0f;
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public void setCompression(int n) {
        this.compression = n;
    }

    public int getCompression() {
        return this.compression;
    }
}

