/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class HaarWaveletFileReader
implements AudioProcessor {
    private final int compression;
    private FileInputStream rawInputStream;

    public HaarWaveletFileReader(String string, int n) {
        this.compression = n;
        try {
            this.rawInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.rawInputStream = null;
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        int n;
        float[] fArray = new float[32];
        byte[] byArray = new byte[(32 - this.compression) * 2];
        int n2 = 0;
        try {
            this.rawInputStream.read(byArray);
            n2 += this.rawInputStream.read();
            n2 += this.rawInputStream.read() << 8;
            n2 += this.rawInputStream.read() << 16;
            n2 += this.rawInputStream.read() << 24;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n3 = 0;
        for (n = 0; n < fArray.length; ++n) {
            float f;
            if ((n2 & 1 << n) == 1 << n) continue;
            int n4 = byArray[n3] & 0xFF;
            int n5 = byArray[++n3] << 8;
            ++n3;
            fArray[n] = f = (float)(n4 |= n5) / 32767.0f;
        }
        audioEvent.setFloatBuffer(fArray);
        n = 1;
        try {
            n = this.rawInputStream.available() > 0 ? 1 : 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n != 0;
    }

    @Override
    public void processingFinished() {
        try {
            this.rawInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

