/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class HaarWaveletFileWriter
implements AudioProcessor {
    private final int compression;
    private FileOutputStream rawOutputStream;

    public HaarWaveletFileWriter(String string, int n) {
        this.compression = n;
        try {
            this.rawOutputStream = new FileOutputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.rawOutputStream = null;
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] != 0.0f || n2 >= this.compression) continue;
            ++n2;
            n |= 1 << i;
        }
        assert (n2 == this.compression);
        byte[] byArray = new byte[(fArray.length - this.compression) * 2];
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            float f;
            if ((f = fArray[n3++]) == 0.0f && n2 < this.compression) {
                ++n2;
                --i;
                continue;
            }
            int n4 = (int)((double)f * 32767.0);
            byArray[i] = (byte)n4;
            byArray[++i] = (byte)(n4 >>> 8);
        }
        try {
            this.rawOutputStream.write(byArray);
            this.rawOutputStream.write((byte)n);
            this.rawOutputStream.write((byte)(n >>> 8));
            this.rawOutputStream.write((byte)(n >>> 16));
            this.rawOutputStream.write((byte)(n >>> 24));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    @Override
    public void processingFinished() {
        try {
            this.rawOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

