/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet;

public class HaarWaveletTransform {
    private final boolean preserveEnergy;
    private final float sqrtTwo = (float)Math.sqrt(2.0);

    public HaarWaveletTransform(boolean bl) {
        this.preserveEnergy = bl;
    }

    public HaarWaveletTransform() {
        this(false);
    }

    public void transform(float[] fArray) {
        int n = fArray.length;
        assert (HaarWaveletTransform.isPowerOfTwo(n));
        int n2 = HaarWaveletTransform.log2(n);
        int n3 = 2;
        int n4 = 1;
        for (int i = 0; i < n2; ++i) {
            n /= 2;
            for (int j = 0; j < n; ++j) {
                float f = (fArray[n3 * j] + fArray[n3 * j + n4]) / 2.0f;
                float f2 = (fArray[n3 * j] - fArray[n3 * j + n4]) / 2.0f;
                if (this.preserveEnergy) {
                    f /= this.sqrtTwo;
                    f2 /= this.sqrtTwo;
                }
                fArray[n3 * j] = f;
                fArray[n3 * j + n4] = f2;
            }
            n4 = n3;
            n3 *= 2;
        }
    }

    public void inverseTransform(float[] fArray) {
        int n = fArray.length;
        assert (HaarWaveletTransform.isPowerOfTwo(n));
        int n2 = HaarWaveletTransform.log2(n);
        int n3 = HaarWaveletTransform.pow2(n2 - 1);
        int n4 = 2 * n3;
        n = 1;
        for (int i = n2; i >= 1; --i) {
            for (int j = 0; j < n; ++j) {
                float f = fArray[n4 * j] + fArray[n4 * j + n3];
                float f2 = fArray[n4 * j] - fArray[n4 * j + n3];
                if (this.preserveEnergy) {
                    f *= this.sqrtTwo;
                    f2 *= this.sqrtTwo;
                }
                fArray[n4 * j] = f;
                fArray[n4 * j + n3] = f2;
            }
            n4 = n3;
            n3 /= 2;
            n = 2 * n;
        }
    }

    public static boolean isPowerOfTwo(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("number: " + n);
        }
        return (n & -n) == n;
    }

    public static int log2(int n) {
        if (n == 0) {
            return 0;
        }
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    public static int pow2(int n) {
        return 1 << n;
    }
}

