/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet.lift;

import be.tarsos.dsp.wavelet.lift.LiftingSchemeBaseWavelet;

public class Daubechies4Wavelet
extends LiftingSchemeBaseWavelet {
    static final float sqrt3 = (float)Math.sqrt(3.0);
    static final float sqrt2 = (float)Math.sqrt(2.0);

    protected void normalize(float[] fArray, int n, int n2) {
        int n3 = n >> 1;
        for (int i = 0; i < n3; ++i) {
            if (n2 == 1) {
                fArray[i] = (sqrt3 - 1.0f) / sqrt2 * fArray[i];
                fArray[i + n3] = (sqrt3 + 1.0f) / sqrt2 * fArray[i + n3];
                continue;
            }
            if (n2 == 2) {
                fArray[i] = (sqrt3 + 1.0f) / sqrt2 * fArray[i];
                fArray[i + n3] = (sqrt3 - 1.0f) / sqrt2 * fArray[i + n3];
                continue;
            }
            System.out.println("Daubechies4Wavelet::normalize: bad direction value");
            break;
        }
    }

    @Override
    protected void predict(float[] fArray, int n, int n2) {
        int n3 = n >> 1;
        if (n2 == 1) {
            fArray[n3] = fArray[n3] - sqrt3 / 4.0f * fArray[0] - (sqrt3 - 2.0f) / 4.0f * fArray[n3 - 1];
        } else if (n2 == 2) {
            fArray[n3] = fArray[n3] + sqrt3 / 4.0f * fArray[0] + (sqrt3 - 2.0f) / 4.0f * fArray[n3 - 1];
        } else {
            System.out.println("Daubechies4Wavelet::predict: bad direction value");
        }
        for (int i = 1; i < n3; ++i) {
            if (n2 == 1) {
                fArray[n3 + i] = fArray[n3 + i] - sqrt3 / 4.0f * fArray[i] - (sqrt3 - 2.0f) / 4.0f * fArray[i - 1];
                continue;
            }
            if (n2 != 2) break;
            fArray[n3 + i] = fArray[n3 + i] + sqrt3 / 4.0f * fArray[i] + (sqrt3 - 2.0f) / 4.0f * fArray[i - 1];
        }
    }

    protected void updateOne(float[] fArray, int n, int n2) {
        int n3 = n >> 1;
        for (int i = 0; i < n3; ++i) {
            float f = sqrt3 * fArray[n3 + i];
            if (n2 == 1) {
                fArray[i] = fArray[i] + f;
                continue;
            }
            if (n2 == 2) {
                fArray[i] = fArray[i] - f;
                continue;
            }
            System.out.println("Daubechies4Wavelet::updateOne: bad direction value");
            break;
        }
    }

    @Override
    protected void update(float[] fArray, int n, int n2) {
        int n3 = n >> 1;
        for (int i = 0; i < n3 - 1; ++i) {
            if (n2 == 1) {
                fArray[i] = fArray[i] - fArray[n3 + i + 1];
                continue;
            }
            if (n2 == 2) {
                fArray[i] = fArray[i] + fArray[n3 + i + 1];
                continue;
            }
            System.out.println("Daubechies4Wavelet::update: bad direction value");
            break;
        }
        if (n2 == 1) {
            fArray[n3 - 1] = fArray[n3 - 1] - fArray[n3];
        } else if (n2 == 2) {
            fArray[n3 - 1] = fArray[n3 - 1] + fArray[n3];
        }
    }

    @Override
    public void forwardTrans(float[] fArray) {
        int n;
        for (int i = n = fArray.length; i > 1; i >>= 1) {
            this.split(fArray, i);
            this.updateOne(fArray, i, 1);
            this.predict(fArray, i, 1);
            this.update(fArray, i, 1);
            this.normalize(fArray, i, 1);
        }
    }

    @Override
    public void inverseTrans(float[] fArray) {
        int n = fArray.length;
        for (int i = 2; i <= n; i <<= 1) {
            this.normalize(fArray, i, 2);
            this.update(fArray, i, 2);
            this.predict(fArray, i, 2);
            this.updateOne(fArray, i, 2);
            this.merge(fArray, i);
        }
    }
}

