/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet.lift;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.wavelet.lift.Daubechies4Wavelet;
import java.util.Arrays;

public class Daubechies4WaveletCoder
implements AudioProcessor {
    private final Daubechies4Wavelet transform = new Daubechies4Wavelet();
    private int compression;

    public Daubechies4WaveletCoder() {
        this(16);
    }

    public Daubechies4WaveletCoder(int n) {
        this.compression = n;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        float[] fArray2 = new float[fArray.length];
        this.transform.forwardTrans(fArray);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray2[i] = Math.abs(fArray[i]);
        }
        Arrays.sort(fArray2);
        double d = fArray2[this.compression];
        for (int i = 0; i < fArray.length; ++i) {
            if (!((double)Math.abs(fArray[i]) <= d)) continue;
            fArray[i] = 0.0f;
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public void setCompression(int n) {
        this.compression = n;
    }

    public int getCompression() {
        return this.compression;
    }
}

