/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet.lift;

import be.tarsos.dsp.wavelet.lift.LiftingSchemeBaseWavelet;

public class HaarWavelet
extends LiftingSchemeBaseWavelet {
    @Override
    protected void predict(float[] fArray, int n, int n2) {
        int n3 = n >> 1;
        for (int i = 0; i < n3; ++i) {
            float f = fArray[i];
            int n4 = i + n3;
            if (n2 == 1) {
                fArray[n4] = fArray[n4] - f;
                continue;
            }
            if (n2 == 2) {
                fArray[n4] = fArray[n4] + f;
                continue;
            }
            System.out.println("HaarWavelet::predict: bad direction value");
        }
    }

    public void forwardTransOne(float[] fArray) {
        int n = fArray.length;
        this.split(fArray, n);
        this.predict(fArray, n, 1);
        this.update(fArray, n, 1);
    }

    @Override
    protected void update(float[] fArray, int n, int n2) {
        int n3 = n >> 1;
        for (int i = 0; i < n3; ++i) {
            int n4 = i + n3;
            float f = fArray[n4] / 2.0f;
            if (n2 == 1) {
                fArray[i] = fArray[i] + f;
                continue;
            }
            if (n2 == 2) {
                fArray[i] = fArray[i] - f;
                continue;
            }
            System.out.println("update: bad direction value");
        }
    }
}

