/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet.lift;

public abstract class LiftingSchemeBaseWavelet {
    protected final int forward = 1;
    protected final int inverse = 2;

    protected void split(float[] fArray, int n) {
        int n2 = 1;
        for (int i = n - 1; n2 < i; ++n2, --i) {
            for (int j = n2; j < i; j += 2) {
                float f = fArray[j];
                fArray[j] = fArray[j + 1];
                fArray[j + 1] = f;
            }
        }
    }

    protected void merge(float[] fArray, int n) {
        int n2 = n >> 1;
        int n3 = n2 - 1;
        int n4 = n2;
        while (n3 > 0) {
            for (int i = n3; i < n4; i += 2) {
                float f = fArray[i];
                fArray[i] = fArray[i + 1];
                fArray[i + 1] = f;
            }
            --n3;
            ++n4;
        }
    }

    protected abstract void predict(float[] var1, int var2, int var3);

    protected abstract void update(float[] var1, int var2, int var3);

    public void forwardTrans(float[] fArray) {
        int n;
        for (int i = n = fArray.length; i > 1; i >>= 1) {
            this.split(fArray, i);
            this.predict(fArray, i, 1);
            this.update(fArray, i, 1);
        }
    }

    public void inverseTrans(float[] fArray) {
        int n = fArray.length;
        for (int i = 2; i <= n; i <<= 1) {
            this.update(fArray, i, 2);
            this.predict(fArray, i, 2);
            this.merge(fArray, i);
        }
    }
}

